package com.ejianc.business.supervise.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 进度产值
 * 
 * @author generator
 * 
 */
public class SuperviseProductionVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织id
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long supplierId; // 申报单位
    private String supplierName; // 申报单位名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date productionDate; // 填报日期
    private Long contractId; // 合同
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal sbMny; // 本次申报产值
    private BigDecimal sbScale; // 本次申报产值占比
    private BigDecimal approveMny; // 本次审核产值
    private BigDecimal approveScale; // 本次审核产值占比
    private BigDecimal approveSumMny; // 累计审核产值(含本期)
    private BigDecimal approveSumScale; // 累计审核产值占比
    private BigDecimal lastApproveMny; // 上次累计审核产值
    private Long employeeId; // 填报人
    private String employeeName; // 填报人名称
    private String memo; // 备注
    private String billStateName;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getProductionDate() {
        return productionDate;
    }

    public void setProductionDate(Date productionDate) {
        this.productionDate = productionDate;
    }
    @ReferSerialTransfer(referCode="sub-contract-register")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getSbMny() {
        return sbMny;
    }

    public void setSbMny(BigDecimal sbMny) {
        this.sbMny = sbMny;
    }
    public BigDecimal getSbScale() {
        return sbScale;
    }

    public void setSbScale(BigDecimal sbScale) {
        this.sbScale = sbScale;
    }
    public BigDecimal getApproveMny() {
        return approveMny;
    }

    public void setApproveMny(BigDecimal approveMny) {
        this.approveMny = approveMny;
    }
    public BigDecimal getApproveScale() {
        return approveScale;
    }

    public void setApproveScale(BigDecimal approveScale) {
        this.approveScale = approveScale;
    }
    public BigDecimal getApproveSumMny() {
        return approveSumMny;
    }

    public void setApproveSumMny(BigDecimal approveSumMny) {
        this.approveSumMny = approveSumMny;
    }
    public BigDecimal getApproveSumScale() {
        return approveSumScale;
    }

    public void setApproveSumScale(BigDecimal approveSumScale) {
        this.approveSumScale = approveSumScale;
    }
    public BigDecimal getLastApproveMny() {
        return lastApproveMny;
    }

    public void setLastApproveMny(BigDecimal lastApproveMny) {
        this.lastApproveMny = lastApproveMny;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
