package com.ejianc.business.targetmanage.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.targetmanage.bean.YearTargetEntity;
import com.ejianc.business.targetmanage.service.IYearTargetService;
import com.ejianc.business.targetmanage.vo.YearTargetVO;

/**
 * 总目标年度目标主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("yearTarget")
public class YearTargetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "YEAR_TARGET";//此处需要根据实际修改

    @Autowired
    private IYearTargetService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<YearTargetVO> saveOrUpdate(@RequestBody YearTargetVO saveOrUpdateVO) {
    	YearTargetEntity entity = BeanMapper.map(saveOrUpdateVO, YearTargetEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            //如果编码为空，就新增编码
            if (StringUtils.isBlank(entity.getBillCode())){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }else {
                //验证编码是否唯一
                if (service.checkSameBillCode(BeanMapper.map(entity, YearTargetVO.class))){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }
        }else {
            //校验编码
            if (StringUtils.isBlank(entity.getBillCode())){
                YearTargetEntity oldEntity = service.selectById(entity.getId());
                entity.setBillCode(oldEntity.getBillCode());
            }else {
                //验证编码是否唯一
                if (service.checkSameBillCode(BeanMapper.map(entity, YearTargetVO.class))){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }
        }
    	service.saveOrUpdate(entity, false);
    	YearTargetVO vo = BeanMapper.map(entity, YearTargetVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<YearTargetVO> queryDetail(Long id) {
    	YearTargetEntity entity = service.selectById(id);
    	YearTargetVO vo = BeanMapper.map(entity, YearTargetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<YearTargetVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (YearTargetVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(YearTargetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<YearTargetVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("yearTargetDispatchName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<YearTargetEntity> page = service.queryPage(param,false);
        IPage<YearTargetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<YearTargetVO> voList = BeanMapper.mapList(page.getRecords(), YearTargetVO.class);
        voList.forEach(e -> {
            switch (e.getUrgencyDegree()) {
                case 0:
                    e.setUrgencyDegreeName("特急");
                    break;
                case 1:
                    e.setUrgencyDegreeName("急");
                    break;
                case 2:
                    e.setUrgencyDegreeName("一般");
                    break;
            }
            switch (e.getSecretLevel()) {
                case 0:
                    e.setSecretLevelName("公开");
                    break;
                case 1:
                    e.setSecretLevelName("秘密");
                    break;
                case 2:
                    e.setSecretLevelName("机密");
                    break;
                case 3:
                    e.setSecretLevelName("绝密");
                    break;
            }
        });
  		pageData.setRecords(voList);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("yearTargetDispatchName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<YearTargetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<YearTargetVO> voList = BeanMapper.mapList(list, YearTargetVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            switch (e.getUrgencyDegree()) {
                case 0:
                    e.setUrgencyDegreeName("特急");
                    break;
                case 1:
                    e.setUrgencyDegreeName("急");
                    break;
                case 2:
                    e.setUrgencyDegreeName("一般");
                    break;
            }
            switch (e.getSecretLevel()) {
                case 0:
                    e.setSecretLevelName("公开");
                    break;
                case 1:
                    e.setSecretLevelName("秘密");
                    break;
                case 2:
                    e.setSecretLevelName("机密");
                    break;
                case 3:
                    e.setSecretLevelName("绝密");
                    break;
            }
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("YearTarget-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refYearTargetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<YearTargetVO>> refYearTargetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<YearTargetEntity> page = service.queryPage(param,false);
        IPage<YearTargetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), YearTargetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
