package com.ejianc.business.urgenthandle.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.urgenthandle.vo.AccidentCheckReportVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.urgenthandle.mapper.AccidentCheckReportMapper;
import com.ejianc.business.urgenthandle.bean.AccidentCheckReportEntity;
import com.ejianc.business.urgenthandle.service.IAccidentCheckReportService;

/**
 * 事故调查报告主实体
 * 
 * @author generator
 * 
 */
@Service("accidentCheckReportService")
public class AccidentCheckReportServiceImpl extends BaseServiceImpl<AccidentCheckReportMapper, AccidentCheckReportEntity> implements IAccidentCheckReportService{

    @Override
    public boolean checkSameBillCode(AccidentCheckReportVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<AccidentCheckReportEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(AccidentCheckReportEntity::getBillCode, vo.getBillCode());
        lambda.eq(AccidentCheckReportEntity::getTenantId, tenantId);
        if (null != vo.getId() && vo.getId() > 0) {
            lambda.ne(AccidentCheckReportEntity::getId, vo.getId());
        }
        return super.list(lambda).size() > 0;
    }
}
