/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.inspect.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.inspect.bean.DangerDetermineEntity;
import com.ejianc.business.inspect.service.IDangerDetermineService;
import com.ejianc.business.inspect.vo.DangerDetermineVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dangerDetermine"})
public class DangerDetermineController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    private static final String BILL_CODE = "DANGER_DETERMINE";
    @Autowired
    private IDangerDetermineService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectApi projectApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DangerDetermineVO> saveOrUpdate(@RequestBody DangerDetermineVO saveOrUpdateVO) {
        DangerDetermineEntity entity = (DangerDetermineEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), DangerDetermineEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        DangerDetermineVO vo = (DangerDetermineVO)((Object)BeanMapper.map((Object)((Object)entity), DangerDetermineVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DangerDetermineVO> queryDetail(Long id) {
        DangerDetermineEntity entity = (DangerDetermineEntity)((Object)this.service.selectById(id));
        DangerDetermineVO vo = (DangerDetermineVO)((Object)BeanMapper.map((Object)((Object)entity), DangerDetermineVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DangerDetermineVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DangerDetermineVO dangerDetermineVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DangerDetermineVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("dangerDetermineName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DangerDetermineVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("dangerDetermineName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, DangerDetermineVO.class);
        voList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        beans.put("records", voList);
        ExcelExport.getInstance().export("DangerDetermine-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDangerDetermineData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DangerDetermineVO>> refDangerDetermineData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DangerDetermineVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/projectNotSettleReportWarn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> projectNotSettleReportWarn(@RequestBody JSONArray jsonParam) {
        List projectData;
        CommonResponse jsonArrayCommonResponse;
        this.logger.info("\u5224\u65ad\u8be5\u5b63\u5ea6\u662f\u5426\u505a\u8fc7\u91cd\u5927\u4e8b\u6545\u9690\u60a3\u5224\u5b9a\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        HashMap<Long, ProjectRegisterVO> projectIdMap = new HashMap<Long, ProjectRegisterVO>();
        CommonResponse projectIdCommonResponse = this.projectApi.getProjectIdsByEngineeringType(2, null);
        if (projectIdCommonResponse.isSuccess() && null != projectIdCommonResponse.getData() && (jsonArrayCommonResponse = this.projectApi.queryProjectByIds((List)projectIdCommonResponse.getData())).isSuccess() && null != jsonArrayCommonResponse.getData() && CollectionUtils.isNotEmpty((Collection)((Collection)jsonArrayCommonResponse.getData())) && CollectionUtils.isNotEmpty((Collection)(projectData = (List)jsonArrayCommonResponse.getData()))) {
            this.logger.info("\u9879\u76ee\u4fe1\u606f\u6761\u6570\uff1a{}", (Object)projectData.size());
            for (ProjectRegisterVO project : projectData) {
                projectIdMap.put(project.getId(), project);
            }
        }
        this.logger.info("\u9879\u76ee\u4fe1\u606fmap\u6761\u6570\uff1a{}", (Object)projectIdMap.size());
        if (null == projectIdMap) {
            return CommonResponse.success((String)"\u65e0\u5bf9\u5e94\u72b6\u6001\u9879\u76ee\u6570\u636e\uff01");
        }
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            if (null != tenantId && tenantId != 999999L) continue;
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
            lambda2.eq(BaseEntity::getTenantId, (Object)999999L);
            lambda2.in(DangerDetermineEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            String year = com.ejianc.business.util.DateUtil.getYear() + "";
            int month = com.ejianc.business.util.DateUtil.getMonth();
            if (month <= 3) {
                lambda2.ge(DangerDetermineEntity::getSelfExaminationDate, (Object)(year + "-01-01"));
            } else if (month <= 6) {
                lambda2.ge(DangerDetermineEntity::getSelfExaminationDate, (Object)(year + "-04-01"));
            } else if (month <= 9) {
                lambda2.ge(DangerDetermineEntity::getSelfExaminationDate, (Object)(year + "-07-01"));
            } else {
                lambda2.ge(DangerDetermineEntity::getSelfExaminationDate, (Object)(year + "-10-01"));
            }
            lambda2.in(DangerDetermineEntity::getProjectId, projectIdMap.keySet());
            List dangerDetermineEntityList = this.service.list((Wrapper)lambda2);
            List dangerDetermineProjectIdList = dangerDetermineEntityList.stream().map(DangerDetermineEntity::getProjectId).distinct().collect(Collectors.toList());
            this.logger.info("\u5df2\u505a\u91cd\u5927\u4e8b\u6545\u9690\u60a3\u5224\u5b9a\u7684\u9879\u76eeid\uff1a{}", (Object)JSONObject.toJSONString(dangerDetermineProjectIdList));
            ArrayList unDangerDetermineList = new ArrayList();
            projectIdMap.forEach((key, value) -> {
                if (!dangerDetermineEntityList.contains(key)) {
                    unDangerDetermineList.add(projectIdMap.get(key));
                }
            });
            if (null == unDangerDetermineList || !ListUtil.isNotEmpty(unDangerDetermineList)) continue;
            for (ProjectRegisterVO project : unDangerDetermineList) {
                int i1;
                OrgVO orgVO;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = project.getOrgId();
                if (orgId == null || (orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData()) == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                Integer day = null;
                Boolean exFlag = false;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    day = set.getIntValue("parameterValue");
                    DateTime endDay = DateUtil.endOfQuarter((Date)new Date());
                    int diffDayNum = com.ejianc.business.util.DateUtil.differentDays(new Date(), (Date)endDay) + 1;
                    if (diffDayNum == day) {
                        System.out.println("\u6b63\u786e\u65f6\u95f4");
                        exFlag = true;
                    }
                    this.logger.info("\u9879\u76ee\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)project));
                    if ("\u9ad8".equals(set.getString("warningLevel"))) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel"))) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel"))) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low || !exFlag.booleanValue()) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + project.getName());
                vo.setPcTitle("\u5728\u5efa\u542f\u7528\u9879\u76ee\u672a\u5b8c\u6210\u91cd\u5927\u4e8b\u6545\u9690\u60a3\u5224\u5b9a");
                vo.setOrgId(project.getOrgId());
                vo.setSendOrgId(project.getOrgId() + "");
                vo.setOrgName(project.getOrgName());
                vo.setSourceId(project.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                this.logger.info("tmContent:{}", (Object)tmpContent);
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(project.getName())));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(project.getName())));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(project.getName())));
                }
                warnList.add(vo);
            }
        }
        this.logger.error("\u9884\u8b66\u4fe1\u606f\u6761\u6570\uff0c{}", (Object)warnList.size());
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }
}

