package com.ejianc.business.inspect.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.util.DateUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.inspect.bean.DangerDetermineEntity;
import com.ejianc.business.inspect.service.IDangerDetermineService;
import com.ejianc.business.inspect.vo.DangerDetermineVO;

/**
 * 重大事故隐患判定主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dangerDetermine")
public class DangerDetermineController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;

    private static final String BILL_CODE = "DANGER_DETERMINE";//此处需要根据实际修改

    @Autowired
    private IDangerDetermineService service;

    @Autowired
    private SessionManager sessionManager;


    @Autowired
    private IProjectApi projectApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DangerDetermineVO> saveOrUpdate(@RequestBody DangerDetermineVO saveOrUpdateVO) {
    	DangerDetermineEntity entity = BeanMapper.map(saveOrUpdateVO, DangerDetermineEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	DangerDetermineVO vo = BeanMapper.map(entity, DangerDetermineVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DangerDetermineVO> queryDetail(Long id) {
    	DangerDetermineEntity entity = service.selectById(id);
    	DangerDetermineVO vo = BeanMapper.map(entity, DangerDetermineVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DangerDetermineVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DangerDetermineVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DangerDetermineVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DangerDetermineVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("dangerDetermineName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<DangerDetermineEntity> page = service.queryPage(param,false);
        IPage<DangerDetermineVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DangerDetermineVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("dangerDetermineName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<DangerDetermineEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<DangerDetermineVO> voList = BeanMapper.mapList(list, DangerDetermineVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("DangerDetermine-export.xlsx", beans, response);
    }


    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDangerDetermineData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DangerDetermineVO>> refDangerDetermineData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DangerDetermineEntity> page = service.queryPage(param,false);
        IPage<DangerDetermineVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DangerDetermineVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     *  定时预警--  判断该季度是否做过重大事故隐患判定
     */
    @RequestMapping(value = "/projectNotDangerDetermineReportWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> projectNotDangerDetermineReportWarn(@RequestBody JSONArray jsonParam) {
        /**
         * 获取配置的天数
         * 如果到这一天代码才往下进行
         * 如果是10
         * 获取三月、六月、九月、十二月减十天 获取四个准确日期
         * 获取当前时间，如果月份在1-3，则跟三月准确时间对比，如果月份在4-6，则跟六月准确时间对比
         *
         * 判断当前月份 如果是3月
         * 判断当前月份，如果是
         * 1、2、3只查一月到现在的数据
         * 7、8、9只查七月之后的数据
         */


        logger.info("判断该季度是否做过重大事故隐患判定收到 Task 参数：{}", jsonParam);
        //1、获取项目信息
        Map<Long, ProjectRegisterVO> projectIdMap = new HashMap<>();

        CommonResponse<List<Long>> projectIdCommonResponse = projectApi.getProjectIdsByEngineeringType(2, null);
        if (projectIdCommonResponse.isSuccess() && null != projectIdCommonResponse.getData()){
            CommonResponse<List<ProjectRegisterVO>> jsonArrayCommonResponse = projectApi.queryProjectByIds(projectIdCommonResponse.getData());
            if(jsonArrayCommonResponse.isSuccess() && null!=jsonArrayCommonResponse.getData() && CollectionUtils.isNotEmpty(jsonArrayCommonResponse.getData())){
                List<ProjectRegisterVO> projectData = jsonArrayCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(projectData)){
                    logger.info("项目信息条数：{}",projectData.size());
                    for (ProjectRegisterVO project : projectData) {
                        projectIdMap.put(project.getId(), project);
                    }
                }
            }
        }
        logger.info("项目信息map条数：{}",projectIdMap.size());
        if (null == projectIdMap){
            return CommonResponse.success("无对应状态项目数据！");
        }

        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            if(null!=tenantId&&tenantId!=999999L){
                continue;
            }
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户纬度，查询出来需要预警的数据
            // 2、根据单据所属组织，找到对应的预警设置，也就是这条适用于那个设置
            // 3、根据预警设置判断该数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据

            //2、该季度未做过重大事故隐患判定的项目
            LambdaQueryWrapper<DangerDetermineEntity> lambda2 = new LambdaQueryWrapper<DangerDetermineEntity>();
            lambda2.eq(DangerDetermineEntity::getTenantId, 999999L);
            lambda2.in(DangerDetermineEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
            //放置时间区间查询条件
            String year = DateUtil.getYear() + "";
            int month = DateUtil.getMonth();
            if (month <= 3){
                lambda2.ge(DangerDetermineEntity::getSelfExaminationDate, year + "-01" + "-01");
            }else if (month <= 6){
                lambda2.ge(DangerDetermineEntity::getSelfExaminationDate, year + "-04" + "-01");
            }else if (month <= 9){
                lambda2.ge(DangerDetermineEntity::getSelfExaminationDate, year + "-07" + "-01");
            }else {
                lambda2.ge(DangerDetermineEntity::getSelfExaminationDate, year + "-10" + "-01");
            }

            lambda2.in(DangerDetermineEntity::getProjectId, projectIdMap.keySet());
            List<DangerDetermineEntity> dangerDetermineEntityList = service.list(lambda2);

            List<Long> dangerDetermineProjectIdList = dangerDetermineEntityList.stream().map(DangerDetermineEntity::getProjectId).distinct().collect(Collectors.toList());
            logger.info("已做重大事故隐患判定的项目id：{}", JSONObject.toJSONString(dangerDetermineProjectIdList));
            List<ProjectRegisterVO> unDangerDetermineList = new ArrayList<>();
            projectIdMap.forEach((key, value) ->{
                if(!dangerDetermineEntityList.contains(key)){
                    //未做重大事故隐患判定的项目
                    unDangerDetermineList.add(projectIdMap.get(key));
                }
            });

            if (null!=unDangerDetermineList && ListUtil.isNotEmpty(unDangerDetermineList)) {
                for (ProjectRegisterVO project : unDangerDetermineList) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = project.getOrgId();
                    if(orgId==null){
                        continue;
                    }
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if(orgVO==null){
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______"+innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0 ; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if(orgSet!=null){
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }

                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;

                        Integer day = null;
                        Boolean exFlag = false;

                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);

                            //获取天数（该季度前多少天）
                            day = set.getIntValue("parameterValue");

                            //判断当前时间是否是这一天
                            Date endDay = cn.hutool.core.date.DateUtil.endOfQuarter(new Date());
                            int diffDayNum = DateUtil.differentDays(new Date(), endDay) + 1;

                            //todo 如果不配置这地方可能有问题
                            if (diffDayNum == day){
                                System.out.println("正确时间");
                                exFlag = true;
                            }

                            logger.info("项目信息：{}", JSONObject.toJSONString(project));
                            if ("高".equals(set.getString("warningLevel"))) {
                                high = true;
                                useSetHigh = set;
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                meddle = true;
                                useSetMeddle = set;
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                low = true;
                                useSetLow = set;
                            }
                        }
                        if ((high || meddle || low) && exFlag) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +project.getName());
                            vo.setPcTitle("在建启用项目未完成重大事故隐患判定");
                            vo.setOrgId(project.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(project.getOrgId()+"");
                            vo.setOrgName(project.getOrgName());
                            vo.setSourceId(project.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            logger.info("tmContent:{}", tmpContent);
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(project.getName()))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(project.getName()))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(project.getName()))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        logger.error("预警信息条数，{}", warnList.size());
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }


}
