package com.ejianc.business.inspect.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.inspect.vo.SqlParam;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.util.DateUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.inspect.bean.DangerDetermineEntity;
import com.ejianc.business.inspect.service.IDangerDetermineService;
import com.ejianc.business.inspect.vo.DangerDetermineVO;

/**
 * 重大事故隐患判定主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dangerDetermine")
public class DangerDetermineController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;

    private static final String BILL_CODE = "DANGER_DETERMINE";//此处需要根据实际修改

    private static final String PC_URL_PROJECT = "/ejc-market-frontend/#/card?id=";

    @Autowired
    private IDangerDetermineService service;

    @Autowired
    private SessionManager sessionManager;


    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private ITenantApi tenantApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DangerDetermineVO> saveOrUpdate(@RequestBody DangerDetermineVO saveOrUpdateVO) {
    	DangerDetermineEntity entity = BeanMapper.map(saveOrUpdateVO, DangerDetermineEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	DangerDetermineVO vo = BeanMapper.map(entity, DangerDetermineVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DangerDetermineVO> queryDetail(Long id) {
    	DangerDetermineEntity entity = service.selectById(id);
    	DangerDetermineVO vo = BeanMapper.map(entity, DangerDetermineVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DangerDetermineVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DangerDetermineVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DangerDetermineVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DangerDetermineVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("dangerDetermineName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<DangerDetermineEntity> page = service.queryPage(param,false);
        IPage<DangerDetermineVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DangerDetermineVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("dangerDetermineName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<DangerDetermineEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<DangerDetermineVO> voList = BeanMapper.mapList(list, DangerDetermineVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("DangerDetermine-export.xlsx", beans, response);
    }


    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDangerDetermineData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DangerDetermineVO>> refDangerDetermineData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DangerDetermineEntity> page = service.queryPage(param,false);
        IPage<DangerDetermineVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DangerDetermineVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     *  定时预警--  在建启用项目在该季度未完成重大事故隐患判定
     *  判断该季度是否做过重大事故隐患判定
     *
     */
    @RequestMapping(value = "/projectNotDangerDetermineReportWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> projectNotDangerDetermineReportWarn(@RequestBody JSONObject jsonObject) {
        logger.info("接收到Task参数：{}", jsonObject);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonObject.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonObject.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonObject.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonObject.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);


        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if(!tenantResp.isSuccess()) {
            logger.error("执行在建启用项目在该季度未完成重大事故隐患判定到期预警失败，获取有效的租户Id列表失败：{}", tenantResp.getMsg());
            return CommonResponse.error("执行在建启用项目在该季度未完成重大事故隐患判定失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if(CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行在建启用项目在该季度未完成重大事故隐患判定完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //去掉停用的预警对应的租户Id
        tenantIds.removeAll(ignoreTenantIds);
        if(CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行在建启用项目在该季度未完成重大事故隐患判定完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }


        //获取租户id
        List<SqlParam> sqlParamList = new ArrayList<>();
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();

        Integer day = null;

        for(JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));

                logger.info("获取天数（该季度前多少天）：{}", p.getValue());
                //获取天数（该季度前多少天）
                day = p.getValue().intValue();

                //判断当前时间是否是这一天
                Date endDay = cn.hutool.core.date.DateUtil.endOfQuarter(new Date());
                int diffDayNum = DateUtil.differentDays(new Date(), endDay) + 1;

                if (diffDayNum == day){
                    //正确时间
                    sqlParamList.add(p);
                }


            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }

        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);

        for(Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);

                logger.info("获取天数（该季度前多少天）：{}", p.getValue());
                //获取天数（该季度前多少天）
                day = p.getValue().intValue();

                //判断当前时间是否是这一天
                Date endDay = cn.hutool.core.date.DateUtil.endOfQuarter(new Date());
                int diffDayNum = DateUtil.differentDays(new Date(), endDay) + 1;

                if (diffDayNum == day){
                    //正确时间
                    sqlParamList.add(p);
                }
            }
        }

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(sqlParamList)){
            logger.error("未到设定时间，不执行该项操作！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }


        List<Long> tenantIdList = new ArrayList<>();
        for (SqlParam param : sqlParamList) {
            tenantIdList.add(param.getTenantId());
        }


        //1、获取所有对应项目
        Map<Long, ProjectRegisterVO> projectIdMap = new HashMap<>();
        QueryParam queryProjectParam = new QueryParam();
        //项目查询时需要校验 tenantId
        queryProjectParam.getParams().put("tenantId", new Parameter(QueryParam.IN, tenantIdList));
        queryProjectParam.getParams().put("withoutOrgFlag", new Parameter(QueryParam.EQ, true));
        queryProjectParam.getParams().put("status", new Parameter(QueryParam.EQ, 2));
        queryProjectParam.setPageIndex(1);
        queryProjectParam.setPageSize(-1);

        CommonResponse<List<ProjectRegisterVO>> projectCommonResponse = projectApi.queryAllProj(queryProjectParam);
        if (projectCommonResponse.isSuccess() && null != projectCommonResponse.getData()){
            List<ProjectRegisterVO> projectList = projectCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(projectList)){
                logger.info("项目信息条数：{}",projectList.size());
                for (ProjectRegisterVO project : projectList) {
                    projectIdMap.put(project.getId(), project);
                }
            }
        }
        logger.info("项目信息map条数：{}", projectIdMap.size());
        if (null == projectIdMap){
            return CommonResponse.success("无对应状态项目数据 或 当前时间未到设置时间！");
        }



        //2、该季度未做过重大事故隐患判定的项目
        LambdaQueryWrapper<DangerDetermineEntity> lambda2 = new LambdaQueryWrapper<DangerDetermineEntity>();
        lambda2.in(DangerDetermineEntity::getTenantId, tenantIdList);
        lambda2.in(DangerDetermineEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        //放置时间区间查询条件
        String year = DateUtil.getYear() + "";
        int month = DateUtil.getMonth();
        if (month <= 3){
            lambda2.ge(DangerDetermineEntity::getCreateTime, year + "-01" + "-01");
        }else if (month <= 6){
            lambda2.ge(DangerDetermineEntity::getCreateTime, year + "-04" + "-01");
        }else if (month <= 9){
            lambda2.ge(DangerDetermineEntity::getCreateTime, year + "-07" + "-01");
        }else {
            lambda2.ge(DangerDetermineEntity::getCreateTime, year + "-10" + "-01");
        }
        lambda2.in(DangerDetermineEntity::getProjectId, projectIdMap.keySet());
        List<DangerDetermineEntity> dangerDetermineEntityList = service.list(lambda2);


        if(CollectionUtils.isEmpty(dangerDetermineEntityList)) {
            logger.error("执行在建启用项目在该季度未完成重大事故隐患判定预警完成，未发现有匹配预警规则的信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }


        //3.筛选出未做重大事故隐患判定的项目数据
        List<Long> dangerDetermineProjectIdList = dangerDetermineEntityList.stream().map(DangerDetermineEntity::getProjectId).distinct().collect(Collectors.toList());
        logger.info("已做重大事故隐患判定的项目id：{}", JSONObject.toJSONString(dangerDetermineProjectIdList));
        List<ProjectRegisterVO> unDangerDetermineList = new ArrayList<>();

        projectIdMap.forEach((key, value) ->{
            if(!dangerDetermineProjectIdList.contains(key)){
                //未提交结算报审的数据  取第一条(时间为最新一期的)
                unDangerDetermineList.add(projectIdMap.get(key));
            } });



        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        for (ProjectRegisterVO warnVo : unDangerDetermineList) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName("执行在建启用项目在该季度未完成重大事故隐患判定-"+warnVo.getCode());
            vo.setPcTitle("执行在建启用项目在该季度未完成重大事故隐患判定");
            vo.setPcUrl(PC_URL_PROJECT + warnVo.getId());
            vo.setOrgId(Long.valueOf(warnVo.getOrgId()));
            vo.setOrgName(warnVo.getOrgName());
            vo.setTenantId(Long.valueOf(warnVo.getTenantId()));
            vo.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#projectName#", warnVo.getName())
                            .replaceAll("#quarterNum#", cn.hutool.core.date.DateUtil.quarter(new Date()) + "")
            );
            resp.add(vo);
        }

        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }


    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        logger.info("发送任务：{}", JSONObject.toJSONString(warnList));
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

}
