/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.inspect.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.inspect.bean.IdentifyEntity;
import com.ejianc.business.inspect.service.IIdentifyService;
import com.ejianc.business.inspect.vo.IdentifyVO;
import com.ejianc.business.inspect.vo.SqlParam;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"identify"})
public class IdentifyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "QUALITY_IDENTIFY";
    private static final String PC_URL_PROJECT = "/ejc-market-frontend/#/card?id=";
    @Autowired
    private IIdentifyService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private ITenantApi tenantApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IdentifyVO> saveOrUpdate(@RequestBody IdentifyVO saveOrUpdateVO) {
        IdentifyEntity entity = (IdentifyEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), IdentifyEntity.class));
        if ((entity.getId() == null || entity.getId() == 0L) && StringUtils.isAllBlank((CharSequence[])new CharSequence[]{saveOrUpdateVO.getBillCode()})) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBillQuarter(DateUtil.quarter((Date)entity.getBillMonth()));
        this.service.saveOrUpdate((Object)entity, false);
        IdentifyVO vo = (IdentifyVO)((Object)BeanMapper.map((Object)((Object)entity), IdentifyVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IdentifyVO> queryDetail(Long id) {
        IdentifyEntity entity = (IdentifyEntity)((Object)this.service.selectById(id));
        IdentifyVO vo = (IdentifyVO)((Object)BeanMapper.map((Object)((Object)entity), IdentifyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<IdentifyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (IdentifyVO identifyVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<IdentifyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), IdentifyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (IdentifyEntity entity : list) {
                entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)entity.getBillState()).getDescription());
            }
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("Identify-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refIdentifyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<IdentifyVO>> refIdentifyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), IdentifyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/projectNotIdentifyReportWarn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> projectNotIdentifyReportWarn(@RequestBody JSONObject jsonObject) {
        List projectList;
        int diffDayNum;
        DateTime endDay;
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonObject);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonObject.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonObject.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonObject.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u5728\u5efa\u542f\u7528\u9879\u76ee\u5728\u8be5\u5b63\u5ea6\u672a\u5b8c\u6210\u5371\u9669\u6e90\u52a8\u6001\u8fa8\u8bc6\u5230\u671f\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u5728\u5efa\u542f\u7528\u9879\u76ee\u5728\u8be5\u5b63\u5ea6\u672a\u5b8c\u6210\u5371\u9669\u6e90\u52a8\u6001\u8fa8\u8bc6\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u5728\u5efa\u542f\u7528\u9879\u76ee\u5728\u8be5\u5b63\u5ea6\u672a\u5b8c\u6210\u5371\u9669\u6e90\u52a8\u6001\u8fa8\u8bc6\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(ignoreTenantIds) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u5728\u5efa\u542f\u7528\u9879\u76ee\u5728\u8be5\u5b63\u5ea6\u672a\u5b8c\u6210\u5371\u9669\u6e90\u52a8\u6001\u8fa8\u8bc6\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        Integer day = null;
        for (JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                this.logger.info("\u83b7\u53d6\u5929\u6570\uff08\u8be5\u5b63\u5ea6\u524d\u591a\u5c11\u5929\uff09\uff1a{}", (Object)p.getValue());
                day = p.getValue().intValue();
                endDay = DateUtil.endOfQuarter((Date)new Date());
                diffDayNum = com.ejianc.business.util.DateUtil.differentDays(new Date(), (Date)endDay) + 1;
                if (0 > diffDayNum || diffDayNum > day) continue;
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        for (Object tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId((Long)tenantId);
                this.logger.info("\u83b7\u53d6\u5929\u6570\uff08\u8be5\u5b63\u5ea6\u524d\u591a\u5c11\u5929\uff09\uff1a{}", (Object)p.getValue());
                day = p.getValue().intValue();
                endDay = DateUtil.endOfQuarter((Date)new Date());
                diffDayNum = com.ejianc.business.util.DateUtil.differentDays(new Date(), (Date)endDay) + 1;
                if (0 > diffDayNum || diffDayNum > day) continue;
                sqlParamList.add(p);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(sqlParamList)) {
            this.logger.error("\u672a\u5230\u8bbe\u5b9a\u65f6\u95f4\uff0c\u4e0d\u6267\u884c\u8be5\u9879\u64cd\u4f5c\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<Long> tenantIdList = new ArrayList<Long>();
        for (SqlParam param : sqlParamList) {
            tenantIdList.add(param.getTenantId());
        }
        HashMap<Long, ProjectRegisterVO> projectIdMap = new HashMap<Long, ProjectRegisterVO>();
        QueryParam queryProjectParam = new QueryParam();
        queryProjectParam.getParams().put("tenantId", new Parameter("in", tenantIdList));
        queryProjectParam.getParams().put("withoutOrgFlag", new Parameter("eq", (Object)true));
        queryProjectParam.getParams().put("status", new Parameter("eq", (Object)2));
        queryProjectParam.setPageIndex(1);
        queryProjectParam.setPageSize(-1);
        CommonResponse projectCommonResponse = this.projectApi.queryAllProj(queryProjectParam);
        if (projectCommonResponse.isSuccess() && null != projectCommonResponse.getData() && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(projectList = (List)projectCommonResponse.getData()))) {
            this.logger.info("\u9879\u76ee\u4fe1\u606f\u6761\u6570\uff1a{}", (Object)projectList.size());
            for (ProjectRegisterVO project : projectList) {
                projectIdMap.put(project.getId(), project);
            }
        }
        this.logger.info("\u9879\u76ee\u4fe1\u606fmap\u6761\u6570\uff1a{}", (Object)projectIdMap.size());
        if (null == projectIdMap) {
            return CommonResponse.success((String)"\u65e0\u5bf9\u5e94\u72b6\u6001\u9879\u76ee\u6570\u636e \u6216 \u5f53\u524d\u65f6\u95f4\u672a\u5230\u8bbe\u7f6e\u65f6\u95f4\uff01");
        }
        LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
        lambda2.in(BaseEntity::getTenantId, tenantIdList);
        lambda2.in(IdentifyEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        String year = com.ejianc.business.util.DateUtil.getYear() + "";
        int month = com.ejianc.business.util.DateUtil.getMonth();
        if (month <= 3) {
            lambda2.ge(BaseEntity::getCreateTime, (Object)(year + "-01-01"));
        } else if (month <= 6) {
            lambda2.ge(BaseEntity::getCreateTime, (Object)(year + "-04-01"));
        } else if (month <= 9) {
            lambda2.ge(BaseEntity::getCreateTime, (Object)(year + "-07-01"));
        } else {
            lambda2.ge(BaseEntity::getCreateTime, (Object)(year + "-10-01"));
        }
        lambda2.in(IdentifyEntity::getProjectId, projectIdMap.keySet());
        List identifyEntityList = this.service.list((Wrapper)lambda2);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)identifyEntityList)) {
            this.logger.error("\u6267\u884c\u5728\u5efa\u542f\u7528\u9879\u76ee\u5728\u8be5\u5b63\u5ea6\u672a\u5b8c\u6210\u5371\u9669\u6e90\u52a8\u6001\u8fa8\u8bc6\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        List identifyProjectIdList = identifyEntityList.stream().map(IdentifyEntity::getProjectId).distinct().collect(Collectors.toList());
        this.logger.info("\u5df2\u505a\u5371\u9669\u6e90\u52a8\u6001\u8fa8\u8bc6\u7684\u9879\u76eeid\uff1a{}", (Object)JSONObject.toJSONString(identifyProjectIdList));
        ArrayList unIdentifyList = new ArrayList();
        projectIdMap.forEach((key, value) -> {
            if (!identifyProjectIdList.contains(key)) {
                unIdentifyList.add(projectIdMap.get(key));
            }
        });
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (ProjectRegisterVO warnVo : unIdentifyList) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName("\u6267\u884c\u5728\u5efa\u542f\u7528\u9879\u76ee\u5728\u8be5\u5b63\u5ea6\u672a\u5b8c\u6210\u5371\u9669\u6e90\u52a8\u6001\u8fa8\u8bc6-" + warnVo.getCode());
            vo.setPcTitle("\u6267\u884c\u5728\u5efa\u542f\u7528\u9879\u76ee\u5728\u8be5\u5b63\u5ea6\u672a\u5b8c\u6210\u5371\u9669\u6e90\u52a8\u6001\u8fa8\u8bc6");
            vo.setPcUrl(PC_URL_PROJECT + warnVo.getId());
            vo.setOrgId(Long.valueOf(warnVo.getOrgId()));
            vo.setOrgName(warnVo.getOrgName());
            vo.setTenantId(Long.valueOf(warnVo.getTenantId()));
            vo.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", warnVo.getName()).replaceAll("#quarterNum#", DateUtil.quarter((Date)new Date()) + ""));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        this.logger.info("\u53d1\u9001\u4efb\u52a1\uff1a{}", (Object)JSONObject.toJSONString(warnList));
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }
}

