package com.ejianc.business.targetmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetmanage.vo.ProductionMeetingVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.targetmanage.mapper.ProductionMeetingMapper;
import com.ejianc.business.targetmanage.bean.ProductionMeetingEntity;
import com.ejianc.business.targetmanage.service.IProductionMeetingService;

/**
 * 安全生产会议主实体
 * 
 * @author generator
 * 
 */
@Service("productionMeetingService")
public class ProductionMeetingServiceImpl extends BaseServiceImpl<ProductionMeetingMapper, ProductionMeetingEntity> implements IProductionMeetingService{

    @Override
    public boolean checkSameBillCode(ProductionMeetingVO vo) {

        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ProductionMeetingEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ProductionMeetingEntity::getBillCode, vo.getBillCode());
        lambda.eq(ProductionMeetingEntity::getTenantId, tenantId);
        if (null != vo.getId() && vo.getId() > 0) {
            lambda.ne(ProductionMeetingEntity::getId, vo.getId());
        }
        return super.list(lambda).size() > 0;
    }
}
