package com.ejianc.business.quatity.controller;


import com.ejianc.business.quatity.service.SystemDocServer;
import com.ejianc.framework.core.response.CommonResponse;
import groovy.util.logging.Slf4j;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @Author: LCL
 * @Date: 2024/5/10 上午9:14
 * @Description: 体系文件
 */

@Controller
@RequestMapping("systemDoc")
@RequiredArgsConstructor
@Slf4j
public class SystemDocController {
    private final SystemDocServer server;

    /**
     * 标准库——新增
     */
    @RequestMapping(value = "standard/add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> standardAdd() {
        return CommonResponse.success("标准库——新增");
    }


    /**
     * 制度库——新增
     */
    @RequestMapping(value = "institutional/add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> institutionalAdd() {
        return CommonResponse.success("制度库——新增");
    }

    /**
     * 标准库——查询
     */
    @RequestMapping(value = "standard/list", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> standardList() {
        return CommonResponse.success("标准库——查询");
    }

    /**
     * 制度库——查询
     */
    @RequestMapping(value = "institutional/list", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> institutionalList() {
        return CommonResponse.success("制度库——查询");
    }

    /**
     * 删除
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> del() {
        return CommonResponse.success("删除");
    }

    /**
     * 标准库——导出
     */
    @RequestMapping(value = "standard/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> standardExcelExport() {
        return CommonResponse.success("标准库——导出");
    }

    /**
     * 制度库——导出
     */
    @RequestMapping(value = "institutional/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> institutionalExcelExport() {
        return CommonResponse.success("制度库——导出");
    }

}
