package com.ejianc.business.quatity.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午2:57
 * @Description: 适用范围(公司部门 、 公司直管项目 、 公司所属单位 / 项目)
 */
@Getter
@AllArgsConstructor
public enum ApplicableScopeEnum {
    /**
     * 公司部门
     */
    DEPARTMENT("department", "公司部门"),
    /**
     * 公司直管项目
     */
    STRAIGHTPIPES("StraightPipes", "公司直管项目"),
    /**
     * 公司所属单位/项目
     */
    AFFILIATIONPROJECT("AffiliationProject", "公司所属单位/项目"),
    ;

    private final String scopeCode;

    private final String scopeName;

    public static final ApplicableScopeEnum[] VALUES;

    static {
        VALUES = values();
    }
}
