package com.ejianc.business.quatity.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午2:57
 * @Description: 体系文件-来源
 */
@Getter
@AllArgsConstructor
public enum SystemDocumentsOriginEnum {
    /**
     * OA平台数据
     */
    OA("OA", "OA平台数据"),
    /**
     * ZTPC平台自建
     */
    ZTPC("ZTPC", "ZTPC平台自建"),
    /**
     * 制度库
     */
    INSTITUTIONAL("institutional", "制度库"),
    /**
     * 标准库
     */
    STANDARD("standard", "标准库"),
    ;

    private final String originCode;

    private final String originName;

    public static final SystemDocumentsOriginEnum[] VALUES;

    static {
        VALUES = values();
    }
}
