package com.ejianc.business.quatity.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.SysDocInstitutionalLibEntity;
import com.ejianc.business.quatity.entity.SysDocStandardLibEntity;
import com.ejianc.business.quatity.model.vo.SysDocDelVo;
import com.ejianc.business.quatity.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quatity.model.vo.SysDocListVo;
import com.ejianc.business.quatity.model.vo.SysDocStandardAddVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午4:05
 * @Description: 体系文件
 */
public interface SystemDocServer {
    /**
     * 标准库——新增
     *
     * @param vo SysDocStandardAddVo
     * @see SysDocStandardAddVo
     */
    void standardAdd(SysDocStandardAddVo vo);

    /**
     * 制度库——新增
     *
     * @param vo SysDocInstitutionalAddVo
     * @see SysDocInstitutionalAddVo
     */
    void institutionalAdd(SysDocInstitutionalAddVo vo);

    /**
     * 标准库——查询
     *
     * @param vo SysDocListVo
     * @return 分页数据
     * @see SysDocListVo
     */
    IPage<SysDocStandardLibEntity> standardList(SysDocListVo vo);

    /**
     * 制度库——查询
     *
     * @param vo SysDocListVo
     * @return 分页数据
     * @see SysDocListVo
     */
    IPage<SysDocInstitutionalLibEntity> institutionalList(SysDocListVo vo);

    /**
     * 删除
     *
     * @param vo SysDocDelVo
     * @see SysDocDelVo
     */
    void del(SysDocDelVo vo);

    /**
     * 标准库——导出
     *
     * @param ids      数据id
     * @param response 请求
     * @return excel文件
     */
    void standardExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 制度库——导出
     *
     * @param ids      数据id
     * @param response 请求
     * @return excel文件
     */
    void institutionalExcelExport(List<Long> ids, HttpServletResponse response);
}
