package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.quatity.dao.InstitutionalLibraryDao;
import com.ejianc.business.quatity.dao.StandardLibraryDao;
import com.ejianc.business.quatity.entity.SysDocInstitutionalLibEntity;
import com.ejianc.business.quatity.entity.SysDocStandardLibEntity;
import com.ejianc.business.quatity.enums.SystemDocumentsOriginEnum;
import com.ejianc.business.quatity.model.vo.SysDocDelVo;
import com.ejianc.business.quatity.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quatity.model.vo.SysDocListVo;
import com.ejianc.business.quatity.model.vo.SysDocStandardAddVo;
import com.ejianc.business.quatity.service.SystemDocServer;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午4:05
 * @Description: 体系文件
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class SystemDocServerImpl implements SystemDocServer {
    /**
     * 制度库
     */
    private static final String INSTITUTIONAL = SystemDocumentsOriginEnum.INSTITUTIONAL.getOriginCode();
    private final InstitutionalLibraryDao institutionalLibraryDao;
    /**
     * 标准库
     */
    private static final String STANDARD = SystemDocumentsOriginEnum.STANDARD.getOriginCode();
    private final StandardLibraryDao standardLibraryDao;

    @Override
    public void standardAdd(SysDocStandardAddVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties(vo, sysDocStandardLibEntity);
        try {
            standardLibraryDao.save(sysDocStandardLibEntity);
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public void institutionalAdd(SysDocInstitutionalAddVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties(vo, sysDocInstitutionalLibEntity);
        try {
            institutionalLibraryDao.save(sysDocInstitutionalLibEntity);
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<SysDocStandardLibEntity> standardList(SysDocListVo vo) {
        String gltx = vo.getGltx();
        String orgId = vo.getOrgId();
        String parentOrgId = vo.getParentOrgId();
        LambdaQueryWrapper<SysDocStandardLibEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getDr, NumberUtils.INTEGER_ZERO);
        if (StrUtil.isNotEmpty(gltx)) {
            lambdaQuery.eq(SysDocStandardLibEntity::getGltx, gltx);
        }
        if (StrUtil.isNotEmpty(orgId)) {
            lambdaQuery.eq(SysDocStandardLibEntity::getOrgId, orgId);
        }
        if (StrUtil.isNotEmpty(parentOrgId)) {
            lambdaQuery.eq(SysDocStandardLibEntity::getParentOrgId, parentOrgId);
        }

        return standardLibraryDao.page(vo.buildPage(), lambdaQuery);
    }


    @Override
    public IPage<SysDocInstitutionalLibEntity> institutionalList(SysDocListVo vo) {
        String gltx = vo.getGltx();
        String orgId = vo.getOrgId();
        String parentOrgId = vo.getParentOrgId();
        LambdaQueryWrapper<SysDocInstitutionalLibEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getDr, NumberUtils.INTEGER_ZERO);
        if (StrUtil.isNotEmpty(gltx)) {
            lambdaQuery.eq(SysDocInstitutionalLibEntity::getGltx, gltx);
        }
        if (StrUtil.isNotEmpty(orgId)) {
            lambdaQuery.eq(SysDocInstitutionalLibEntity::getOrgId, orgId);
        }
        if (StrUtil.isNotEmpty(parentOrgId)) {
            lambdaQuery.eq(SysDocInstitutionalLibEntity::getParentOrgId, parentOrgId);
        }

        return institutionalLibraryDao.page(vo.buildPage(), lambdaQuery);

    }

    @Override
    public void del(SysDocDelVo vo) {
        String type = vo.getType();
        if (!INSTITUTIONAL.equals(type) && !STANDARD.equals(type)) {
            throw new BusinessException("文件库类型不存在:【标准库standard/制度库institutional】");
        }
        try {
            if (INSTITUTIONAL.equals(type)) {
                institutionalLibraryDao.removeByIds(vo.getIds());
            }
            if (STANDARD.equals(type)) {
                standardLibraryDao.removeByIds(vo.getIds());
            }
        } catch (Exception e) {
            throw new BusinessException("体系文件删除失败：" + e.getMessage());
        }
    }

    @Override
    public void standardExcelExport(List<Long> ids, HttpServletResponse response) {
        List<SysDocStandardLibEntity> list = standardLibraryDao.lambdaQuery().in(BaseEntity::getId, ids).list();

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("standardSystemDocExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("标准库体系文件导出失败：" + e.getMessage());
        }
    }

    @Override
    public void institutionalExcelExport(List<Long> ids, HttpServletResponse response) {
        List<SysDocInstitutionalLibEntity> list = institutionalLibraryDao.lambdaQuery().in(BaseEntity::getId, ids).list();

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("institutionalSystemDocExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("制度库体系文件导出失败：" + e.getMessage());
        }
    }
}
