/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.quatity.dao.InstitutionalLibraryDao;
import com.ejianc.business.quatity.dao.StandardLibraryDao;
import com.ejianc.business.quatity.entity.SysDocInstitutionalLibEntity;
import com.ejianc.business.quatity.entity.SysDocStandardLibEntity;
import com.ejianc.business.quatity.enums.SystemDocumentsOriginEnum;
import com.ejianc.business.quatity.model.vo.SysDocDelVo;
import com.ejianc.business.quatity.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quatity.model.vo.SysDocListVo;
import com.ejianc.business.quatity.model.vo.SysDocStandardAddVo;
import com.ejianc.business.quatity.service.SystemDocServer;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SystemDocServerImpl
implements SystemDocServer {
    private static final Logger log = LoggerFactory.getLogger(SystemDocServerImpl.class);
    private static final String INSTITUTIONAL = SystemDocumentsOriginEnum.INSTITUTIONAL.getOriginCode();
    private final InstitutionalLibraryDao institutionalLibraryDao;
    private static final String STANDARD = SystemDocumentsOriginEnum.STANDARD.getOriginCode();
    private final StandardLibraryDao standardLibraryDao;

    @Override
    public void standardAdd(SysDocStandardAddVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)sysDocStandardLibEntity));
        try {
            this.standardLibraryDao.save((Object)sysDocStandardLibEntity);
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public void institutionalAdd(SysDocInstitutionalAddVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)sysDocInstitutionalLibEntity));
        try {
            this.institutionalLibraryDao.save((Object)sysDocInstitutionalLibEntity);
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<SysDocStandardLibEntity> standardList(SysDocListVo vo) {
        String gltx = vo.getGltx();
        String orgId = vo.getOrgId();
        String parentOrgId = vo.getParentOrgId();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getDr, (Object)NumberUtils.INTEGER_ZERO);
        if (StrUtil.isNotEmpty((CharSequence)gltx)) {
            lambdaQuery.eq(SysDocStandardLibEntity::getGltx, (Object)gltx);
        }
        if (StrUtil.isNotEmpty((CharSequence)orgId)) {
            lambdaQuery.eq(SysDocStandardLibEntity::getOrgId, (Object)orgId);
        }
        if (StrUtil.isNotEmpty((CharSequence)parentOrgId)) {
            lambdaQuery.eq(SysDocStandardLibEntity::getParentOrgId, (Object)parentOrgId);
        }
        return this.standardLibraryDao.page((IPage)vo.buildPage(), (Wrapper)lambdaQuery);
    }

    @Override
    public IPage<SysDocInstitutionalLibEntity> institutionalList(SysDocListVo vo) {
        String gltx = vo.getGltx();
        String orgId = vo.getOrgId();
        String parentOrgId = vo.getParentOrgId();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getDr, (Object)NumberUtils.INTEGER_ZERO);
        if (StrUtil.isNotEmpty((CharSequence)gltx)) {
            lambdaQuery.eq(SysDocInstitutionalLibEntity::getGltx, (Object)gltx);
        }
        if (StrUtil.isNotEmpty((CharSequence)orgId)) {
            lambdaQuery.eq(SysDocInstitutionalLibEntity::getOrgId, (Object)orgId);
        }
        if (StrUtil.isNotEmpty((CharSequence)parentOrgId)) {
            lambdaQuery.eq(SysDocInstitutionalLibEntity::getParentOrgId, (Object)parentOrgId);
        }
        return this.institutionalLibraryDao.page((IPage)vo.buildPage(), (Wrapper)lambdaQuery);
    }

    @Override
    public void del(SysDocDelVo vo) {
        String type = vo.getType();
        if (!INSTITUTIONAL.equals(type) && !STANDARD.equals(type)) {
            throw new BusinessException("\u6587\u4ef6\u5e93\u7c7b\u578b\u4e0d\u5b58\u5728:\u3010\u6807\u51c6\u5e93standard/\u5236\u5ea6\u5e93institutional\u3011");
        }
        try {
            if (INSTITUTIONAL.equals(type)) {
                this.institutionalLibraryDao.removeByIds(vo.getIds());
            }
            if (STANDARD.equals(type)) {
                this.standardLibraryDao.removeByIds(vo.getIds());
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4f53\u7cfb\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void standardExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.standardLibraryDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("standardSystemDocExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u6807\u51c6\u5e93\u4f53\u7cfb\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void institutionalExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.institutionalLibraryDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("institutionalSystemDocExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u5236\u5ea6\u5e93\u4f53\u7cfb\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public SystemDocServerImpl(InstitutionalLibraryDao institutionalLibraryDao, StandardLibraryDao standardLibraryDao) {
        this.institutionalLibraryDao = institutionalLibraryDao;
        this.standardLibraryDao = standardLibraryDao;
    }
}

