package com.ejianc.business.quatity.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.CompanyGoalsEntity;
import com.ejianc.business.quatity.model.vo.CompanyTargetAddVo;
import com.ejianc.business.quatity.model.vo.CompanyTargetListVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午4:05
 * @Description: 目标管理
 */
public interface TargetManagementServer {
    /**
     * 公司目标-新增
     *
     * @param vo CompanyTargetAddVo
     * @return 结果
     * @see CompanyTargetAddVo
     */
    void companyAdd(CompanyTargetAddVo vo);


    /**
     * 公司目标-查询
     *
     * @param vo CompanyTargetListVo
     * @return 结果
     * @see CompanyTargetListVo
     */
    IPage<CompanyGoalsEntity> companyList(CompanyTargetListVo vo);


    /**
     * 公司目标-删除
     *
     * @param ids ids
     */
    void companyDel(List<Long> ids);

    /**
     * 公司目标-导出
     *
     * @param ids      ids
     * @param response response
     */
    void companyExcelExport(List<Long> ids, HttpServletResponse response);


    /**
     * 统一的下载Excel模板
     *
     * @param excelName excel模板名称
     * @param request   请求
     * @param response  返回
     */
    void importDownTemplateDetail(String excelName, HttpServletRequest request, HttpServletResponse response);
}
