package com.ejianc.business.quatity.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.sql.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午3:53
 * @Description: 体系文件-制度库
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_system_documents_institutional_library")
public class SysDocInstitutionalLibEntity extends BaseEntity {
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @TableField(value = "type")
    private String type;

    /**
     * 来源(OA、ZTPC)
     *
     * @see com.ejianc.business.quatity.enums.SystemDocumentsOriginEnum
     */
    @TableField(value = "origin")
    private String origin;

    /**
     * 制度分类
     */
    @TableField(value = "zdfl")
    private String zdfl;

    /**
     * 制度分级
     */
    @TableField(value = "zdfj")
    private String zdfj;

    /**
     * 编制部门
     */
    @TableField(value = "bzbm")
    private String bzbm;

    /**
     * 编制单位
     */
    @TableField(value = "bzdw")
    private String bzdw;

    /**
     * 制度标题
     */
    @TableField(value = "zdbt")
    private String zdbt;

    /**
     * 制度等级
     */
    @TableField(value = "zddj")
    private String zddj;

    /**
     * 制度正文 url地址
     */
    @TableField(value = "zdzw")
    private String zdzw;

    /**
     * 制度版本(V V1 V2 V3 V4 V5 V6 V7 V8 V9 V10)
     *
     * @see com.ejianc.business.quatity.enums.SystemDocumentsStatusEnum
     */
    @TableField(value = "zdbb")
    private String zdbb;

    /**
     * 发文号
     */
    @TableField(value = "fwh")
    private String fwh;

    /**
     * 制度编码
     */
    @TableField(value = "zdbm")
    private String zdbm;

    /**
     * 发布日期
     */
    @TableField(value = "fbrq")
    private Date fbrq;

    /**
     * 审议机构
     */
    @TableField(value = "syjg")
    private String syjg;

    /**
     * 审批机构
     */
    @TableField(value = "spjg")
    private String spjg;

    /**
     * 状态(施行、试行、废止)
     *
     * @see com.ejianc.business.quatity.enums.SystemDocumentsStatusEnum
     */
    @TableField(value = "zt")
    private String zt;

    /**
     * 上级制度来源
     */
    @TableField(value = "sjzdly")
    private String sjzdly;

    /**
     * 公司本部(本部适用、规范至所属单位、规范至所属法人企业)
     */
    @TableField(value = "gsbb")
    private String gsbb;

    /**
     * 子公司(遵照执行、细化执行、参照执行、不适用)
     */
    @TableField(value = "zgs")
    private String zgs;

    /**
     * 分公司(遵照执行、细化执行、参照执行、不适用)
     */
    @TableField(value = "fgs")
    private String fgs;

    /**
     * 直管项目(遵照执行、细化执行、参照执行、不适用)
     */
    @TableField(value = "zgxm")
    private String zgxm;

    /**
     * 归属管理体系
     *
     * @see com.ejianc.business.quatity.enums.ManagementSystemEnum
     */
    @TableField(value = "gltx")
    private String gltx;

    /**
     * 编码
     */
    @TableField(value = "bm")
    private String bm;

    /**
     * 编制人账号
     */
    @TableField(value = "prepared_user_code")
    private String preparedUserCode;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private String orgId;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private String parentOrgId;
}
