package com.ejianc.business.quatity.model.po;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.sql.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/13 下午3:46
 * @Description: 公司目标导入
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CompanyExcelPo {
    /**
     * 目标文件
     */
    @ExcelProperty("目标文件")
    private String targetFile;

    /**
     * 目标上传日期
     */
    @ExcelProperty("目标上传日期")
    @DateTimeFormat("yyyy-MM-dd")
    private String uploadTime;

    /**
     * 所属项目部名称
     */
    @ExcelProperty("所属项目部名称")
    private String orgName;

    /**
     * 项目部上级组织名称
     */
    @ExcelProperty("项目部上级组织名称")
    private String parentOrgName;

}
