package com.ejianc.business.quatity.model.vo;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import javax.validation.constraints.Min;


/**
* @Author: LCL
* @Date: 2024/5/13 上午10:14
* @Description: 接收前端分页查询基类
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class PageVO {
    @Builder.Default
    @Min(value = 1, message = "页码错误")
    private Integer pageNumber = 1;

    @Builder.Default
    private Integer pageSize = 10;

    public <T> Page<T> buildPage() {
        return new Page<>(pageNumber, pageSize);
    }

}
