package com.ejianc.business.quatity.model.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: LCL
 * @Date: 2024/5/13 上午9:29
 * @Description: 体系文件-查询入参
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SysDocListVo extends PageVO{
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;
    /**
     * 归属管理体系
     *
     * @see com.ejianc.business.quatity.enums.ManagementSystemEnum
     */
    private String gltx;

    /**
     * 所属项目部Id
     */
    private String orgId;

    /**
     * 项目部上级组织Id
     */
    private String parentOrgId;
}
