package com.ejianc.business.quatity.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.CompanyGoalsEntity;
import com.ejianc.business.quatity.model.vo.CompanyTargetAddVo;
import com.ejianc.business.quatity.model.vo.CompanyTargetListVo;
import com.ejianc.business.quatity.service.TargetManagementServer;
import com.ejianc.framework.core.response.CommonResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/5/13 下午1:45
 * @Description: 目标管理
 */
@Controller
@RequestMapping("targetManagement")
@RequiredArgsConstructor
public class TargetManagementController {
    private final TargetManagementServer server;

    /**
     * 公司目标-新增
     *
     * @param vo CompanyTargetAddVo
     * @return 结果
     * @see CompanyTargetAddVo
     */
    @RequestMapping(value = "company/add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CompanyGoalsEntity> companyAdd(@RequestBody @Valid CompanyTargetAddVo vo) {
        return CommonResponse.success("公司目标-新增成功",server.companyAdd(vo));
    }

    /**
     * 公司目标-查询
     *
     * @param vo CompanyTargetListVo
     * @return 结果
     * @see CompanyTargetListVo
     */
    @RequestMapping(value = "company/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CompanyGoalsEntity>> companyList(@RequestBody @Valid CompanyTargetListVo vo) {
        return CommonResponse.success("公司目标-查询", server.companyList(vo));
    }

    /**
     * 公司目标-删除
     *
     * @param ids ids
     */
    @RequestMapping(value = "company/del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> companyDel(@RequestBody @Valid List<Long> ids) {
        server.companyDel(ids);
        return CommonResponse.success("公司目标-删除成功");
    }

    /**
     * 公司目标-导出
     *
     * @param ids      ids
     * @param response response
     */
    @RequestMapping(value = "company/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> companyExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.companyExcelExport(ids, response);
        return CommonResponse.success("公司目标-导出成功");
    }

    /**
     * 统一的下载Excel模板
     *
     * @param excelName excel模板名称
     * @param request   请求
     * @param response  返回
     */
    @RequestMapping(value = "downloadExcelTemplate", method = RequestMethod.POST)
    @ResponseBody
    public void importDownTemplateDetail(@RequestParam("excelName") String excelName, HttpServletRequest request, HttpServletResponse response) {
        server.importDownTemplateDetail(excelName, request, response);
    }

    /**
     * 公司目标导入
     *
     * @param file 导入的excel文件
     * @return 结果
     */
    @RequestMapping(value = "company/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> companyExcelImport(@RequestPart("file") MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
        server.companyExcelImport(file,request,response);
        return CommonResponse.success("公司目标-导入成功");
    }

}
