package com.ejianc.business.quatity.model.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.sql.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:53
 * @Description: 内部审核新增
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class InternalAuditsAddVo {
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;

    /**
     * 审核报告名称
     */
    private String auditReportsName;

    /**
     * 审核报告url
     */
    private String auditReports;

    /**
     * 审核计划名称
     */
    private String auditPlanName;

    /**
     * 审核计划url
     */
    private String auditPlan;

    /**
     * 目标上传日期
     */
    private Date uploadTime;

    /**
     * 所属项目部Id
     */
    private String orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    private String parentOrgId;

    /**
     * 项目部上级组织名称
     */
    private String parentOrgName;
}
