package com.ejianc.business.quatity.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午2:57
 * @Description: 体系文件-标准库、制度库-状态(启用、废止(修订)、废止)
 */
@Getter
@AllArgsConstructor
public enum SystemDocumentsStatusEnum {
    /**
     * 标准库——启用
     */
    ENABLE("ENABLE", "启用"),
    /**
     * 标准库——废止(修订)
     */
    REPEALREVISED("REPEAL(REVISED)", "废止(修订)"),
    /**
     * 标准库、制度库——废止
     */
    ABOLITION("ABOLITION", "废止"),
    /**
     * 制度库——施行
     */
    EXECUTION("EXECUTION", "施行"),
    /**
     * 制度库——试行
     */
    TRIAL("TRIAL", "试行"),


    /**
     * 制度库——版本
     */
    V1("V1", "V1"),
    V2("V2", "V2"),
    V3("V3", "V3"),
    V4("V4", "V4"),
    V5("V5", "V5"),
    V6("V6", "V6"),
    V7("V7", "V7"),
    V8("V8", "V8"),
    V9("V9", "V9"),
    V10("V10", "V10"),
    ;

    private final String originCode;

    private final String originName;

    public static final SystemDocumentsStatusEnum[] VALUES;

    static {
        VALUES = values();
    }
}
