package com.ejianc.business.quatity.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.InternalAuditsEntity;
import com.ejianc.business.quatity.model.vo.CompanyTargetAddVo;
import com.ejianc.business.quatity.model.vo.InternalAuditsAddVo;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:43
 * @Description: 内部审核
 */
public interface InternalAuditsServer {

    /**
     * 内部审核-新增
     *
     * @param vo CompanyTargetAddVo
     * @return 结果
     * @see CompanyTargetAddVo
     */
    InternalAuditsEntity add(InternalAuditsAddVo vo);

    /**
     * 内部审核-查询
     *
     * @param param param
     * @return IPage<InternalAuditsEntity>
     */
    IPage<InternalAuditsEntity> list(QueryParam param);

    /**
     * 内部审核-删除
     *
     * @param ids ids
     */
    void del(List<Long> ids);

    /**
     * 内部审核-导出
     *
     * @param ids      ids
     * @param response response
     */
    void internalAuditsExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 内部审核导入
     *
     * @param file 导入的excel文件
     * @return 结果
     */
    void internalAuditsExcelImport(MultipartFile file, HttpServletRequest request, HttpServletResponse response);
}
