package com.ejianc.business.quatity.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @Author: LCL
 * @Date: 2024/5/13 下午3:28
 * @Description: 质量管理   分类(本部、分子公司、项目)
 */
@Getter
@AllArgsConstructor
public enum QualityTypeEnum {
    /**
     * 本部
     */
    HEADQUARTERS("HEADQUARTERS", "本部"),
    /**
     * 分子公司
     */
    MOLECULARCOMPANIES("MOLECULARCOMPANIES", "分子公司"),
    /**
     * 项目
     */
    PROJECT("PROJECT", "项目"),
    ;

    private final String typeCode;

    private final String typeName;

    public static final QualityTypeEnum[] VALUES;

    static {
        VALUES = values();
    }

    public static String getNameByCode(String typeCode) {
        for (QualityTypeEnum qualityTypeEnum : values()) {
            if (qualityTypeEnum.getTypeCode().equals(typeCode)) {
                return qualityTypeEnum.getTypeName();
            }
        }
        return "未知";
    }
}
