package com.ejianc.business.quatity.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.dao.InternalAuditsDao;
import com.ejianc.business.quatity.entity.InternalAuditsEntity;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.model.vo.InternalAuditsAddVo;
import com.ejianc.business.quatity.service.InternalAuditsServer;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:43
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class InternalAuditsServerImpl implements InternalAuditsServer {
    private final InternalAuditsDao internalAuditsDao;

    @Override
    public InternalAuditsEntity add(InternalAuditsAddVo vo) {
        InternalAuditsEntity internalAuditsEntity = new InternalAuditsEntity();
        BeanUtils.copyProperties(vo, internalAuditsEntity);
        try {
            internalAuditsDao.save(internalAuditsEntity);
            return internalAuditsEntity;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<InternalAuditsEntity> list(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("auditReportsName");
        fuzzyFields.add("auditPlanName");

        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);

        return internalAuditsDao.queryPage(param, false);
    }

    @Override
    public void del(List<Long> ids) {
        try {
            internalAuditsDao.removeByIds(ids);
        } catch (Exception e) {
            throw new BusinessException("内部审核删除失败：" + e.getMessage());
        }
    }

    @Override
    public void internalAuditsExcelExport(List<Long> ids, HttpServletResponse response) {
        List<InternalAuditsEntity> list = internalAuditsDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        list.forEach(item -> {
            String typeName = QualityTypeEnum.getNameByCode(item.getType());
            item.setType(typeName);
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("internalAuditsExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("内部审核导出失败：" + e.getMessage());
        }

    }

    @Override
    public void internalAuditsExcelImport(MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
//
//        List<InternalAuditsExcelPo> internalAuditsExcelPoList = new ArrayList<>();
//        if (file == null || file.isEmpty() || ObjectUtils.isEmpty(file.getOriginalFilename())) {
//            throw new BusinessException(500, "文件不能为空");
//        }
//        String fileName = file.getOriginalFilename();
//        if (!(fileName.endsWith(".xlsx") || fileName.endsWith(".xls"))) {
//            throw new BusinessException(500, "文件类型错误，只支持：xlsx、xls");
//        }
//        try {
//            InputStream inputStream = file.getInputStream();
//            EasyExcel.read(inputStream, InternalAuditsExcelPo.class, new AnalysisEventListener<InternalAuditsExcelPo>() {
//                        @Override
//                        public void invoke(InternalAuditsExcelPo companyGoalsExcelPo, AnalysisContext analysisContext) {
//                            internalAuditsExcelPoList.add(companyGoalsExcelPo);
//                        }
//
//                        @Override
//                        public void doAfterAllAnalysed(AnalysisContext analysisContext) {
//                        }
//                    })
//                    .sheet()
//                    .doRead();
//        } catch (IOException e) {
//            log.info("内部审核导入异常:{}", e.getMessage());
//        } catch (ExcelDataConvertException e) {
//            throw new BusinessException("内部审核导入异常");
//        }
//        try {
//            List<InternalAuditsEntity> internalAuditsEntityList = Lists.newArrayList();
//            internalAuditsExcelPoList.forEach(companyGoalsExcelPo -> {
//                InternalAuditsEntity companyGoalsEntity = new InternalAuditsEntity();
//                BeanUtils.copyProperties(companyGoalsExcelPo, companyGoalsEntity);
//                companyGoalsEntity.setUploadTime(DateUtil.parse(companyGoalsExcelPo.getUploadTime(), DateFormater.SHORT_FORMAT).toSqlDate());
//                internalAuditsEntityList.add(companyGoalsEntity);
//            });
//            internalAuditsDao.saveBatch(internalAuditsEntityList);
//        } catch (Exception e) {
//            throw new BusinessException("内部审核导入保存异常");
//        }
    }
}
