package com.ejianc.business.quatity.model.vo;

import com.ejianc.business.quatity.enums.SystemDocumentsOriginEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.sql.Date;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/13 上午9:08
 * @Description: 体系文件-标准库新增入参
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class SysDocStandardAddVo {
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;

    /**
     * 来源(OA、ZTPC)
     *
     * @see com.ejianc.business.quatity.enums.SystemDocumentsOriginEnum
     */
    @Builder.Default
    private String origin = SystemDocumentsOriginEnum.ZTPC.getOriginCode();

    /**
     * 文件编号
     */
    private String wjbh;

    /**
     * 文件名称
     */
    private String wjmc;

    /**
     * 文件内容 url地址
     */
    private String wjnr;

    /**
     * 适用项目类别(核电、火电、送变电、风电、光伏、市政、房建、通用)
     *
     * @see com.ejianc.business.quatity.enums.ApplicableProjectCategoriesEnum
     */
    private String syxmlb;

    /**
     * 适用范围(公司部门、公司直管项目、公司所属单位/项目)
     *
     * @see com.ejianc.business.quatity.enums.ApplicableScopeEnum
     */
    private List<String> syfw;

    /**
     * 状态(启用、废止(修订)、废止)
     *
     * @see com.ejianc.business.quatity.enums.SystemDocumentsStatusEnum
     */
    private String zt;

    /**
     * 备注
     */
    private String bz;

    /**
     * 发布日期
     */
    private Date fbrq;

    /**
     * 实施日期
     */
    private Date ssrq;

    /**
     * 体系结构号
     */
    private String txjgh;

    /**
     * 归属管理体系
     *
     * @see com.ejianc.business.quatity.enums.ManagementSystemEnum
     */
    @NotEmpty(message = "归属管理体系不能为空")
    private String gltx;

    /**
     * 编码
     */
    private String bm;

    /**
     * 编制人账号
     */
    @NotEmpty(message = "编制人不能为空")
    private String preparedUserCode;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    private String parentOrgName;
}
