package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.dao.CompanyGoalsDao;
import com.ejianc.business.quatity.entity.CompanyGoalsEntity;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.model.po.CompanyGoalsExcelPo;
import com.ejianc.business.quatity.model.vo.CompanyTargetAddVo;
import com.ejianc.business.quatity.service.TargetManagementServer;
import com.ejianc.business.quatity.util.DetailIndexExcelReader;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: LCL
 * @Date: 2024/5/13 下午2:08
 * @Description: 目标管理
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class TargetManagementServerImpl implements TargetManagementServer {
    /**
     * 公司目标
     */
    private final CompanyGoalsDao companyGoalsDao;

    @Override
    public CompanyGoalsEntity companyAdd(CompanyTargetAddVo vo) {
        CompanyGoalsEntity companyGoalsEntity = new CompanyGoalsEntity();
        BeanUtils.copyProperties(vo, companyGoalsEntity);
        try {
            companyGoalsDao.save(companyGoalsEntity);
            return companyGoalsEntity;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<CompanyGoalsEntity> companyList(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("targetFileName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("parentOrgName");

        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);

        return companyGoalsDao.queryPage(param, false);
    }

    @Override
    public CompanyGoalsEntity companyDetail(Long id) {
        return companyGoalsDao.getById(id);
    }

    @Override
    public void companyDel(List<Long> ids) {
        try {
            companyGoalsDao.removeByIds(ids);
        } catch (Exception e) {
            throw new BusinessException("公司目标删除失败：" + e.getMessage());
        }
    }

    @Override
    public void companyExcelExport(List<Long> ids, HttpServletResponse response) {
        List<CompanyGoalsEntity> list = companyGoalsDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        //导出展示类别中文处理
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());

            item.setType(type);
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("companyGoalsExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("公司目标导出失败：" + e.getMessage());
        }
    }

    @Override
    public void companyExcelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<CompanyGoalsExcelPo> companyGoalsExcelPoList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            throw new BusinessException("文件格式不合法");
        } else {
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                throw new BusinessException("文件页签不完整，请下载最新模板！");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            for (int i = 0; i < result.size(); i++) {
                CompanyGoalsExcelPo companyGoalsExcelPo = getCompanyGoalsExcelPo(result, i);
                companyGoalsExcelPoList.add(companyGoalsExcelPo);
            }
        }


        try {
            List<CompanyGoalsEntity> companyGoalsEntityList = Lists.newArrayList();
            companyGoalsExcelPoList.forEach(companyGoalsExcelPo -> {
                CompanyGoalsEntity companyGoalsEntity = new CompanyGoalsEntity();
                BeanUtils.copyProperties(companyGoalsExcelPo, companyGoalsEntity);
                companyGoalsEntity.setUploadTime(DateUtil.parse(companyGoalsExcelPo.getUploadTime(), DateFormater.SHORT_FORMAT).toSqlDate());
                companyGoalsEntityList.add(companyGoalsEntity);
            });
            companyGoalsDao.saveBatch(companyGoalsEntityList);
        } catch (Exception e) {
            throw new BusinessException("公司目标导入保存异常");
        }
    }

    private static CompanyGoalsExcelPo getCompanyGoalsExcelPo(List<List<String>> result, int i) {
        List<String> datas = result.get(i);
        CompanyGoalsExcelPo companyGoalsExcelPo = new CompanyGoalsExcelPo();
        String type = datas.get(0);//类别
        String targetFileName = datas.get(1);//目标文件名称
        String targetFile = datas.get(2);//目标文件
        String uploadTime = datas.get(3);///目标上传日期
        String orgName = datas.get(4);//所属项目部名称
        String parentOrgName = datas.get(5);
        companyGoalsExcelPo.setType(type);
        companyGoalsExcelPo.setTargetFileName(targetFileName);
        companyGoalsExcelPo.setTargetFile(targetFile);
        companyGoalsExcelPo.setTargetFile(targetFile);
        companyGoalsExcelPo.setUploadTime(uploadTime);
        companyGoalsExcelPo.setOrgName(orgName);
        companyGoalsExcelPo.setParentOrgName(parentOrgName);
        return companyGoalsExcelPo;
    }
}
