package com.ejianc.business.quatity.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.SysDocInstitutionalLibEntity;
import com.ejianc.business.quatity.entity.SysDocStandardLibEntity;
import com.ejianc.business.quatity.model.vo.SysDocDelVo;
import com.ejianc.business.quatity.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quatity.model.vo.SysDocStandardAddVo;
import com.ejianc.business.quatity.service.SystemDocumentsServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/10 上午9:14
 * @Description: 体系文件
 */

@Controller
@RequestMapping("systemDoc")
@RequiredArgsConstructor
public class SystemDocumentsController {
    private final SystemDocumentsServer server;

    /**
     * 标准库——新增
     *
     * @param vo SysDocStandardAddVo
     * @see SysDocStandardAddVo
     */
    @RequestMapping(value = "standard/add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SysDocStandardLibEntity> standardAdd(@RequestBody @Valid SysDocStandardAddVo vo) {
        return CommonResponse.success("标准库——新增成功", server.standardAdd(vo));
    }

    /**
     * 制度库——新增
     *
     * @param vo SysDocInstitutionalAddVo
     * @see SysDocInstitutionalAddVo
     */
    @RequestMapping(value = "institutional/add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SysDocInstitutionalLibEntity> institutionalAdd(@RequestBody @Valid SysDocInstitutionalAddVo vo) {
        return CommonResponse.success("制度库——新增成功", server.institutionalAdd(vo));
    }

    /**
     * 标准库——查询
     *
     * @param param param
     * @return IPage<SysDocStandardLibEntity>
     */
    @RequestMapping(value = "standard/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SysDocStandardLibEntity>> standardList(@RequestBody QueryParam param) {
        return CommonResponse.success("标准库——查询", server.standardList(param));
    }

    /**
     * 制度库——查询
     *
     * @param param param
     * @return IPage<SysDocInstitutionalLibEntity>
     */
    @RequestMapping(value = "institutional/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SysDocInstitutionalLibEntity>> institutionalList(@RequestBody QueryParam param) {
        return CommonResponse.success("制度库——查询", server.institutionalList(param));
    }

    /**
     * 标准库——详情
     *
     * @param id id
     * @return SysDocStandardLibEntity
     */
    @RequestMapping(value = "standard/detail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SysDocStandardLibEntity> standardDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("标准库详情——查询", server.standardDetail(id));
    }

    /**
     * 制度库——详情
     *
     * @param id id
     * @return SysDocInstitutionalLibEntity
     */
    @RequestMapping(value = "institutional/detail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SysDocInstitutionalLibEntity> institutionalDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("制度库详情——查询", server.institutionalDetail(id));
    }

    /**
     * 删除
     *
     * @param vo SysDocDelVo
     * @see SysDocDelVo
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> del(@RequestBody @Valid SysDocDelVo vo) {
        server.del(vo);
        return CommonResponse.success("体系文件删除成功");
    }

    /**
     * 标准库——导出
     *
     * @param ids      数据id
     * @param response 请求
     * @return excel文件
     */
    @RequestMapping(value = "standard/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> standardExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.standardExcelExport(ids, response);
        return CommonResponse.success("标准库——导出成功");
    }

    /**
     * 制度库——导出
     *
     * @param ids      数据id
     * @param response 请求
     * @return excel文件
     */
    @RequestMapping(value = "institutional/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> institutionalExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.institutionalExcelExport(ids, response);
        return CommonResponse.success("制度库——导出成功");
    }

}
