package com.ejianc.business.quatity.service.impl;

import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.service.ExcelServer;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ImportTemplate;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:48
 * @Description: 统一的Excel服务实现层
 */
@Service
@Slf4j
public class ExcelServerImpl implements ExcelServer {
    /**
     * excel模板名称
     */
    private static final List<String> DOWNLOAD_EXCEL_TEMPLATE_LIST = Lists.newArrayList("companyGoals", "internalAudits");

    @Override
    public void downloadExcelTemplate(String excelName, HttpServletRequest request, HttpServletResponse response) {
        try {
            ImportTemplate.initialize(response);
            if (!DOWNLOAD_EXCEL_TEMPLATE_LIST.contains(excelName)) {
                throw new BusinessException("请指定正确的excel模板名称或联系管理人员");
            }
            if ("companyGoals".equals(excelName)) {
                ImportTemplate.templetdownload(request, "companyGoalsImport.xlsx", "公司目标导入模板");
            }
            if ("internalAudits".equals(excelName)) {
                ImportTemplate.templetdownload(request, "internalAuditsImport.xlsx", "内部审核导入模板");
            }
        } catch (BusinessException e) {
            throw new BusinessException("公司目标excel模板下载失败：" + e.getMessage());
        }

    }
}
