package com.ejianc.business.quatity.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;


/**
 * @Author: LCL
 * @Date: 2024/5/14 下午4:03
 * @Description: 内部审核-不符合项
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_internal_audits")
public class NonConformityEntity extends BaseEntity {
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @TableField(value = "type")
    private String type;

     /**
      * 不符合项分类(观察项、NCR)
      */
     @TableField(value = "conformity_type")
     private String conformityType;

     /**
      * 不符合事实名称
      */
     @TableField(value = "facts_name")
     private String factsName;

     /**
      * 不符合事实url
      */
     @TableField(value = "facts")
     private String facts;

     /**
      * 不符合标准号(NCR)
      */
     @TableField(value = "bfhbzh")
     private String bfhbzh;

     /**
      * 管理类型(观察项)
      * @see com.ejianc.business.quatity.enums.NonConformityTypeEnum
      */
     @TableField(value = "gllx")
     private String gllx;

     /**
      * 归属体系
      * @see com.ejianc.business.quatity.enums.ManagementSystemEnum
      */
     @TableField(value = "gstx")
     private String gstx;

     /**
      * 归属类型
      * @see com.ejianc.business.quatity.enums.NonConformityTypeEnum
      *
      */
     @TableField(value = "gslx")
     private String gslx;

     /**
      * 编制人账号
      */
     @TableField(value = "type")
     private String preparedUserCode;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;
}
