package com.ejianc.business.quatity.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.sql.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午2:52
 * @Description: 体系文件-标准库
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_system_documents_standard_library")
public class SysDocStandardLibEntity extends BaseEntity {
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @TableField(value = "type")
    private String type;

    /**
     * 来源(OA、ZTPC)
     *
     * @see com.ejianc.business.quatity.enums.SystemDocumentsOriginEnum
     */
    @TableField(value = "origin")
    private String origin;

    /**
     * 文件编号
     */
    @TableField(value = "wjbh")
    private String wjbh;

    /**
     * 文件名称
     */
    @TableField(value = "wjmc")
    private String wjmc;

    /**
     * 文件内容 url地址
     */
    @TableField(value = "wjnr")
    private String wjnr;

    /**
     * 适用项目类别(核电、火电、送变电、风电、光伏、市政、房建、通用)
     *
     * @see com.ejianc.business.quatity.enums.ApplicableProjectCategoriesEnum
     */
    @TableField(value = "syxmlb")
    private String syxmlb;

    /**
     * 适用范围(公司部门、公司直管项目、公司所属单位/项目)
     *
     * @see com.ejianc.business.quatity.enums.ApplicableScopeEnum
     */
    @TableField(value = "syfw")
    private String syfw;

    /**
     * 状态(启用、废止(修订)、废止)
     *
     * @see com.ejianc.business.quatity.enums.SystemDocumentsStatusEnum
     */
    @TableField(value = "zt")
    private String zt;

    /**
     * 备注
     */
    @TableField(value = "bz")
    private String bz;

    /**
     * 发布日期
     */
    @TableField(value = "fbrq")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date fbrq;

    /**
     * 实施日期
     */
    @TableField(value = "ssrq")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date ssrq;

    /**
     * 体系结构号
     */
    @TableField(value = "txjgh")
    private String txjgh;

    /**
     * 归属管理体系
     *
     * @see com.ejianc.business.quatity.enums.ManagementSystemEnum
     */
    @TableField(value = "gltx")
    private String gltx;

    /**
     * 编码
     */
    @TableField(value = "bm")
    private String bm;

    /**
     * 编制人账号
     */
    @TableField(value = "prepared_user_code")
    private String preparedUserCode;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;
}
