package com.ejianc.business.quatity.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午2:57
 * @Description: 适用项目类别(核电 、 火电 、 送变电 、 风电 、 光伏 、 市政 、 房建 、 通用)
 */
@Getter
@AllArgsConstructor
public enum ApplicableProjectCategoriesEnum {
    /**
     * 核电项目
     */
    HEDIAN("HEDIAN", "核电项目"),
    /**
     * 火电项目
     */
    HUODIAN("HUODIAN", "火电项目"),
    /**
     * 送变电项目
     */
    SONGBIANDIAN("SONGBIANDIAN", "送变电项目"),
    /**
     * 风电项目
     */
    FENGDIAN("FENGDIAN", "风电项目"),
    /**
     * 光伏项目
     */
    GUANGFU("GUANGFU", "光伏项目"),
    /**
     * 市政项目
     */
    SHIZHENG("SHIZHENG", "市政项目"),
    /**
     * 房建项目
     */
    FANGJIAN("FANGJIAN", "房建项目"),
    /**
     * 通用
     */
    GENERAL("GENERAL", "通用"),
    ;

    private final String projectCode;

    private final String projectName;

    public static final ApplicableProjectCategoriesEnum[] VALUES;

    static {
        VALUES = values();
    }
    public static String getNameByCode(String projectCode) {
        for (ApplicableProjectCategoriesEnum applicableProjectCategoriesEnum : values()) {
            if (applicableProjectCategoriesEnum.getProjectCode().equals(projectCode)) {
                return applicableProjectCategoriesEnum.getProjectName();
            }
        }
        return "未知";
    }
}
