package com.ejianc.business.quatity.model.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.sql.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/14 下午4:34
 * @Description: 不符合项新增
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class NonConformityAddVo {
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;

    /**
     * 不符合项分类(观察项、NCR)
     */
    private String conformityType;

    /**
     * 不符合事实名称
     */
    private String factsName;

    /**
     * 不符合事实url
     */
    private String facts;

    /**
     * 不符合标准号(NCR)
     */
    private String bfhbzh;

    /**
     * 管理类型(观察项)
     */
    private String gllx;

    /**
     * 归属体系
     *
     * @see com.ejianc.business.quatity.enums.ManagementSystemEnum
     */
    private String gstx;

    /**
     * 归属类型
     *
     * @see com.ejianc.business.quatity.enums.NonConformityTypeEnum
     */
    private String gslx;

    /**
     * 编制人账号
     */
    @NotEmpty(message = "编制人不能为空")
    private String preparedUserCode;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    private String parentOrgName;
}
