package com.ejianc.business.quatity.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.InternalAuditsEntity;
import com.ejianc.business.quatity.entity.NonConformityEntity;
import com.ejianc.business.quatity.model.vo.CompanyTargetAddVo;
import com.ejianc.business.quatity.model.vo.InternalAuditsAddVo;
import com.ejianc.business.quatity.model.vo.NonConformityAddVo;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:43
 * @Description: 内部审核
 */
public interface InternalAuditsServer {

    /**
     * 内部审核-新增
     *
     * @param vo CompanyTargetAddVo
     * @return 结果
     * @see CompanyTargetAddVo
     */
    InternalAuditsEntity add(InternalAuditsAddVo vo);

    /**
     * 内部审核-查询
     *
     * @param param param
     * @return IPage<InternalAuditsEntity>
     */
    IPage<InternalAuditsEntity> list(QueryParam param);

    /**
     * 内部审核-详情
     *
     * @param id id
     * @return InternalAuditsEntity
     */
    InternalAuditsEntity detail(Long id);

    /**
     * 内部审核-删除
     *
     * @param ids ids
     */
    void del(List<Long> ids);

    /**
     * 内部审核-导出
     *
     * @param ids      ids
     * @param response response
     */
    void internalAuditsExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 内部审核导入
     *
     * @param request  request
     * @param response response
     * @return 结果
     */
    void internalAuditsExcelImport(HttpServletRequest request, HttpServletResponse response);

    /**
     * 不符合项-新增
     *
     * @param vo NonConformityAddVo
     * @return 结果
     * @see CompanyTargetAddVo
     */
    NonConformityEntity nonConformityAdd(@Valid NonConformityAddVo vo);

    /**
     * 不符合项-查询
     *
     * @param param param
     * @return IPage<InternalAuditsEntity>
     */
    IPage<NonConformityEntity> nonConformityList(QueryParam param);

    /**
     * 不符合项-详情
     *
     * @param id id
     * @return InternalAuditsEntity
     */
    NonConformityEntity nonConformityDetail(Long id);

    /**
     * 不符合项-删除
     *
     * @param ids ids
     */
    void nonConformityDel(List<Long> ids);


    /**
     * 不符合项导入
     *
     * @param excelType     类型 observe观察项  ncr NCR
     * @param request  request
     * @param response response
     * @return结果
     */
    void nonConformityExcelImport(String excelType, HttpServletRequest request, HttpServletResponse response);
}
