package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.dao.InternalAuditsDao;
import com.ejianc.business.quatity.dao.NonConformityDao;
import com.ejianc.business.quatity.entity.InternalAuditsEntity;
import com.ejianc.business.quatity.entity.NonConformityEntity;
import com.ejianc.business.quatity.enums.ManagementSystemEnum;
import com.ejianc.business.quatity.enums.NonConformityTypeEnum;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.model.po.InternalAuditsExcelPo;
import com.ejianc.business.quatity.model.po.NonConformityNcrExcelPo;
import com.ejianc.business.quatity.model.po.NonConformityObserveExcelPo;
import com.ejianc.business.quatity.model.vo.InternalAuditsAddVo;
import com.ejianc.business.quatity.model.vo.NonConformityAddVo;
import com.ejianc.business.quatity.service.InternalAuditsServer;
import com.ejianc.business.quatity.util.DetailIndexExcelReader;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:43
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class InternalAuditsServerImpl implements InternalAuditsServer {
    private final InternalAuditsDao internalAuditsDao;
    private final NonConformityDao nonConformityDao;

    @Override
    public InternalAuditsEntity add(InternalAuditsAddVo vo) {
        InternalAuditsEntity internalAuditsEntity = new InternalAuditsEntity();
        BeanUtils.copyProperties(vo, internalAuditsEntity);
        try {
            internalAuditsDao.save(internalAuditsEntity);
            return internalAuditsEntity;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<InternalAuditsEntity> list(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("auditReportsName");
        fuzzyFields.add("auditPlanName");
        fuzzyFields.add("orgName");


        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);

        return internalAuditsDao.queryPage(param, false);
    }

    @Override
    public InternalAuditsEntity detail(Long id) {
        return internalAuditsDao.getById(id);
    }

    @Override
    public void del(List<Long> ids) {
        try {
            internalAuditsDao.removeByIds(ids);
        } catch (Exception e) {
            throw new BusinessException("内部审核删除失败：" + e.getMessage());
        }
    }

    @Override
    public void internalAuditsExcelExport(List<Long> ids, HttpServletResponse response) {
        List<InternalAuditsEntity> list = internalAuditsDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());
            item.setType(type);
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("internalAuditsExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("内部审核导出失败：" + e.getMessage());
        }

    }

    @Override
    public void internalAuditsExcelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<InternalAuditsExcelPo> internalAuditsExcelPoList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            throw new BusinessException("文件格式不合法");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            throw new BusinessException("文件页签不完整，请下载最新模板！");
        }
        List<List<String>> result = ExcelReader.readExcel(mf);
        for (int i = 0; i < result.size(); i++) {
            InternalAuditsExcelPo internalAuditsExcelPo = getInternalAuditsExcelPo(result, i);
            internalAuditsExcelPoList.add(internalAuditsExcelPo);
        }

        try {
            List<InternalAuditsEntity> internalAuditsEntityList = Lists.newArrayList();
            internalAuditsExcelPoList.forEach(companyGoalsExcelPo -> {
                InternalAuditsEntity companyGoalsEntity = new InternalAuditsEntity();
                BeanUtils.copyProperties(companyGoalsExcelPo, companyGoalsEntity);
                companyGoalsEntity.setUploadTime(DateUtil.parse(companyGoalsExcelPo.getUploadTime(), DateFormater.SHORT_FORMAT).toSqlDate());
                internalAuditsEntityList.add(companyGoalsEntity);
            });
            internalAuditsDao.saveBatch(internalAuditsEntityList);
        } catch (Exception e) {
            throw new BusinessException("内部审核导入保存异常");
        }
    }

    @Override
    public NonConformityEntity nonConformityAdd(@Valid NonConformityAddVo vo) {
        NonConformityEntity internalAuditsEntity = new NonConformityEntity();
        BeanUtils.copyProperties(vo, internalAuditsEntity);
        try {
            nonConformityDao.save(internalAuditsEntity);
            return internalAuditsEntity;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<NonConformityEntity> nonConformityList(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("factsName");
        fuzzyFields.add("gslx");
        fuzzyFields.add("orgName");

        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);

        return nonConformityDao.queryPage(param, false);
    }

    @Override
    public NonConformityEntity nonConformityDetail(Long id) {
        return nonConformityDao.getById(id);
    }

    @Override
    public void nonConformityDel(List<Long> ids) {
        try {
            nonConformityDao.removeByIds(ids);
        } catch (Exception e) {
            throw new BusinessException("内部审核-不符合项删除失败：" + e.getMessage());
        }
    }

    @Override
    public void nonConformityExcelImport(String excelType, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<NonConformityNcrExcelPo> ncrExcelPoList = new ArrayList<>();
        List<NonConformityObserveExcelPo> observeExcelPoList = new ArrayList<>();
        ;

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            throw new BusinessException("文件格式不合法");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            throw new BusinessException("文件页签不完整，请下载最新模板！");
        }
        List<List<String>> result = ExcelReader.readExcel(mf);

        List<NonConformityEntity> nonConformityEntities = Lists.newArrayList();
        //观察项
        if ("observe".equals(excelType)) {
            for (int i = 0; i < result.size(); i++) {
                NonConformityObserveExcelPo nonConformityObserveExcelPo = getNonConformityObserveExcelPo(result, i);
                observeExcelPoList.add(nonConformityObserveExcelPo);
            }

            try {
                observeExcelPoList.forEach(companyGoalsExcelPo -> {
                    NonConformityEntity companyGoalsEntity = new NonConformityEntity();
                    BeanUtils.copyProperties(companyGoalsExcelPo, companyGoalsEntity);
                    //todo
//                    companyGoalsEntity.setConformityType("观察项");
//                    //编制人
//                    companyGoalsEntity.setPreparedUserCode();
//                    //上传部门
//                    companyGoalsEntity.setOrgId();
//                    companyGoalsEntity.setOrgName();
                    nonConformityEntities.add(companyGoalsEntity);
                });
                nonConformityDao.saveBatch(nonConformityEntities);
            } catch (Exception e) {
                throw new BusinessException("不符合观察项导入保存异常");
            }

        }
        //NCR
        if ("ncr".equals(excelType)) {
            for (int i = 0; i < result.size(); i++) {
                NonConformityNcrExcelPo conformityNcrExcelPo = getNonConformityNcrExcelPo(result, i);
                ncrExcelPoList.add(conformityNcrExcelPo);
            }

            try {
                ncrExcelPoList.forEach(companyGoalsExcelPo -> {
                    NonConformityEntity companyGoalsEntity = new NonConformityEntity();
                    BeanUtils.copyProperties(companyGoalsExcelPo, companyGoalsEntity);
                    companyGoalsEntity.setConformityType("NCR");
                    //todo
//                    //编制人
//                    companyGoalsEntity.setPreparedUserCode();
//                    //上传部门
//                    companyGoalsEntity.setOrgId();
//                    companyGoalsEntity.setOrgName();
                    nonConformityEntities.add(companyGoalsEntity);
                });
                nonConformityDao.saveBatch(nonConformityEntities);
            } catch (Exception e) {
                throw new BusinessException("不符合NCR导入保存异常");
            }

        }
    }

    private static NonConformityNcrExcelPo getNonConformityNcrExcelPo(List<List<String>> result, int i) {
        List<String> data = result.get(i);
        NonConformityNcrExcelPo conformityNcrExcelPo = new NonConformityNcrExcelPo();
        String type = data.get(0);//类别
        String factsName = data.get(1);//不符合事实名称
        String facts = data.get(2);//不符合事实url
        String bfhbzh = data.get(3);/// 不符合标准号(NCR)
        String gstx = data.get(4);///归属体系
        String gslx = data.get(5);//归属类型

        conformityNcrExcelPo.setType(QualityTypeEnum.getNameByCode(type));
        conformityNcrExcelPo.setFactsName(factsName);
        conformityNcrExcelPo.setFacts(facts);
        conformityNcrExcelPo.setBfhbzh(bfhbzh);
        conformityNcrExcelPo.setGstx(ManagementSystemEnum.getCodeByName(gstx));
        conformityNcrExcelPo.setGslx(NonConformityTypeEnum.getCodeByName(gslx));
        return conformityNcrExcelPo;
    }

    private static NonConformityObserveExcelPo getNonConformityObserveExcelPo(List<List<String>> result, int i) {
        List<String> data = result.get(i);
        NonConformityObserveExcelPo nonConformityObserveExcelPo = new NonConformityObserveExcelPo();
        String type = data.get(0);//类别
        String factsName = data.get(1);//不符合事实名称
        String facts = data.get(2);//不符合事实url
        String gllx = data.get(3);///管理类型(观察项)
        String gstx = data.get(4);///归属体系
        String gslx = data.get(5);//归属类型

        nonConformityObserveExcelPo.setType(QualityTypeEnum.getNameByCode(type));
        nonConformityObserveExcelPo.setFactsName(factsName);
        nonConformityObserveExcelPo.setFacts(facts);
        nonConformityObserveExcelPo.setGllx(NonConformityTypeEnum.getCodeByName(gllx));
        nonConformityObserveExcelPo.setGstx(ManagementSystemEnum.getCodeByName(gstx));
        nonConformityObserveExcelPo.setGslx(NonConformityTypeEnum.getCodeByName(gslx));
        return nonConformityObserveExcelPo;
    }

    private static InternalAuditsExcelPo getInternalAuditsExcelPo(List<List<String>> result, int i) {
        List<String> data = result.get(i);
        InternalAuditsExcelPo internalAuditsExcelPo = new InternalAuditsExcelPo();
        String type = data.get(0);//类别
        String auditReportsName = data.get(1);//审核报告名称
        String auditReports = data.get(2);//审核报告url
        String auditPlanName = data.get(3);///审核计划名称
        String auditPlan = data.get(4);///审核计划名称
        String uploadTime = data.get(5);//目标上传日期
        String orgName = data.get(6);//所属项目部名称
        String parentOrgName = data.get(7);//项目部上级组织名称

        internalAuditsExcelPo.setType(type);
        internalAuditsExcelPo.setAuditReportsName(auditReportsName);
        internalAuditsExcelPo.setAuditReports(auditReports);
        internalAuditsExcelPo.setAuditPlanName(auditPlanName);
        internalAuditsExcelPo.setAuditPlan(auditPlan);
        internalAuditsExcelPo.setUploadTime(uploadTime);
        internalAuditsExcelPo.setOrgName(orgName);
        internalAuditsExcelPo.setParentOrgName(parentOrgName);
        return internalAuditsExcelPo;
    }
}
