/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.dao.InternalAuditsDao;
import com.ejianc.business.quatity.dao.NonConformityDao;
import com.ejianc.business.quatity.entity.InternalAuditsEntity;
import com.ejianc.business.quatity.entity.NonConformityEntity;
import com.ejianc.business.quatity.enums.ManagementSystemEnum;
import com.ejianc.business.quatity.enums.NonConformityTypeEnum;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.model.po.InternalAuditsExcelPo;
import com.ejianc.business.quatity.model.po.NonConformityNcrExcelPo;
import com.ejianc.business.quatity.model.po.NonConformityObserveExcelPo;
import com.ejianc.business.quatity.model.vo.InternalAuditsAddVo;
import com.ejianc.business.quatity.model.vo.NonConformityAddVo;
import com.ejianc.business.quatity.service.InternalAuditsServer;
import com.ejianc.business.quatity.util.DetailIndexExcelReader;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class InternalAuditsServerImpl
implements InternalAuditsServer {
    private static final Logger log = LoggerFactory.getLogger(InternalAuditsServerImpl.class);
    private final InternalAuditsDao internalAuditsDao;
    private final NonConformityDao nonConformityDao;

    @Override
    public InternalAuditsEntity add(InternalAuditsAddVo vo) {
        InternalAuditsEntity internalAuditsEntity = new InternalAuditsEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)internalAuditsEntity));
        try {
            this.internalAuditsDao.save((Object)internalAuditsEntity);
            return internalAuditsEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<InternalAuditsEntity> list(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("auditReportsName");
        fuzzyFields.add("auditPlanName");
        fuzzyFields.add("orgName");
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>(param.getOrderMap());
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        return this.internalAuditsDao.queryPage(param, false);
    }

    @Override
    public InternalAuditsEntity detail(Long id) {
        return (InternalAuditsEntity)((Object)this.internalAuditsDao.getById(id));
    }

    @Override
    public void del(List<Long> ids) {
        try {
            this.internalAuditsDao.removeByIds(ids);
        }
        catch (Exception e) {
            throw new BusinessException("\u5185\u90e8\u5ba1\u6838\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void internalAuditsExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.internalAuditsDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());
            item.setType(type);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("internalAuditsExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u5185\u90e8\u5ba1\u6838\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void internalAuditsExcelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<InternalAuditsExcelPo> internalAuditsExcelPoList = new ArrayList<InternalAuditsExcelPo>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            throw new BusinessException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            throw new BusinessException("\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        for (int i = 0; i < result.size(); ++i) {
            InternalAuditsExcelPo internalAuditsExcelPo = InternalAuditsServerImpl.getInternalAuditsExcelPo(result, i);
            internalAuditsExcelPoList.add(internalAuditsExcelPo);
        }
        try {
            List internalAuditsEntityList = Lists.newArrayList();
            internalAuditsExcelPoList.forEach(companyGoalsExcelPo -> {
                InternalAuditsEntity companyGoalsEntity = new InternalAuditsEntity();
                BeanUtils.copyProperties((Object)companyGoalsExcelPo, (Object)((Object)companyGoalsEntity));
                companyGoalsEntity.setUploadTime(DateUtil.parse((String)companyGoalsExcelPo.getUploadTime(), (String)"yyyy-MM-dd").toSqlDate());
                internalAuditsEntityList.add(companyGoalsEntity);
            });
            this.internalAuditsDao.saveBatch(internalAuditsEntityList);
        }
        catch (Exception e) {
            throw new BusinessException("\u5185\u90e8\u5ba1\u6838\u5bfc\u5165\u4fdd\u5b58\u5f02\u5e38");
        }
    }

    @Override
    public NonConformityEntity nonConformityAdd(@Valid NonConformityAddVo vo) {
        NonConformityEntity internalAuditsEntity = new NonConformityEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)internalAuditsEntity));
        try {
            this.nonConformityDao.save((Object)internalAuditsEntity);
            return internalAuditsEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<NonConformityEntity> nonConformityList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("factsName");
        fuzzyFields.add("gslx");
        fuzzyFields.add("orgName");
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>(param.getOrderMap());
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        return this.nonConformityDao.queryPage(param, false);
    }

    @Override
    public NonConformityEntity nonConformityDetail(Long id) {
        return (NonConformityEntity)((Object)this.nonConformityDao.getById(id));
    }

    @Override
    public void nonConformityDel(List<Long> ids) {
        try {
            this.nonConformityDao.removeByIds(ids);
        }
        catch (Exception e) {
            throw new BusinessException("\u5185\u90e8\u5ba1\u6838-\u4e0d\u7b26\u5408\u9879\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void nonConformityExcelImport(String excelType, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<NonConformityNcrExcelPo> ncrExcelPoList = new ArrayList<NonConformityNcrExcelPo>();
        ArrayList<NonConformityObserveExcelPo> observeExcelPoList = new ArrayList<NonConformityObserveExcelPo>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            throw new BusinessException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            throw new BusinessException("\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        List nonConformityEntities = Lists.newArrayList();
        if ("observe".equals(excelType)) {
            for (int i = 0; i < result.size(); ++i) {
                NonConformityObserveExcelPo nonConformityObserveExcelPo = InternalAuditsServerImpl.getNonConformityObserveExcelPo(result, i);
                observeExcelPoList.add(nonConformityObserveExcelPo);
            }
            try {
                observeExcelPoList.forEach(companyGoalsExcelPo -> {
                    NonConformityEntity companyGoalsEntity = new NonConformityEntity();
                    BeanUtils.copyProperties((Object)companyGoalsExcelPo, (Object)((Object)companyGoalsEntity));
                    nonConformityEntities.add(companyGoalsEntity);
                });
                this.nonConformityDao.saveBatch(nonConformityEntities);
            }
            catch (Exception e) {
                throw new BusinessException("\u4e0d\u7b26\u5408\u89c2\u5bdf\u9879\u5bfc\u5165\u4fdd\u5b58\u5f02\u5e38");
            }
        }
        if ("ncr".equals(excelType)) {
            for (int i = 0; i < result.size(); ++i) {
                NonConformityNcrExcelPo conformityNcrExcelPo = InternalAuditsServerImpl.getNonConformityNcrExcelPo(result, i);
                ncrExcelPoList.add(conformityNcrExcelPo);
            }
            try {
                ncrExcelPoList.forEach(companyGoalsExcelPo -> {
                    NonConformityEntity companyGoalsEntity = new NonConformityEntity();
                    BeanUtils.copyProperties((Object)companyGoalsExcelPo, (Object)((Object)companyGoalsEntity));
                    companyGoalsEntity.setConformityType("NCR");
                    nonConformityEntities.add(companyGoalsEntity);
                });
                this.nonConformityDao.saveBatch(nonConformityEntities);
            }
            catch (Exception e) {
                throw new BusinessException("\u4e0d\u7b26\u5408NCR\u5bfc\u5165\u4fdd\u5b58\u5f02\u5e38");
            }
        }
    }

    private static NonConformityNcrExcelPo getNonConformityNcrExcelPo(List<List<String>> result, int i) {
        List<String> data = result.get(i);
        NonConformityNcrExcelPo conformityNcrExcelPo = new NonConformityNcrExcelPo();
        String type = data.get(0);
        String factsName = data.get(1);
        String facts = data.get(2);
        String bfhbzh = data.get(3);
        String gstx = data.get(4);
        String gslx = data.get(5);
        conformityNcrExcelPo.setType(QualityTypeEnum.getNameByCode(type));
        conformityNcrExcelPo.setFactsName(factsName);
        conformityNcrExcelPo.setFacts(facts);
        conformityNcrExcelPo.setBfhbzh(bfhbzh);
        conformityNcrExcelPo.setGstx(ManagementSystemEnum.getCodeByName(gstx));
        conformityNcrExcelPo.setGslx(NonConformityTypeEnum.getCodeByName(gslx));
        return conformityNcrExcelPo;
    }

    private static NonConformityObserveExcelPo getNonConformityObserveExcelPo(List<List<String>> result, int i) {
        List<String> data = result.get(i);
        NonConformityObserveExcelPo nonConformityObserveExcelPo = new NonConformityObserveExcelPo();
        String type = data.get(0);
        String factsName = data.get(1);
        String facts = data.get(2);
        String gllx = data.get(3);
        String gstx = data.get(4);
        String gslx = data.get(5);
        nonConformityObserveExcelPo.setType(QualityTypeEnum.getNameByCode(type));
        nonConformityObserveExcelPo.setFactsName(factsName);
        nonConformityObserveExcelPo.setFacts(facts);
        nonConformityObserveExcelPo.setGllx(NonConformityTypeEnum.getCodeByName(gllx));
        nonConformityObserveExcelPo.setGstx(ManagementSystemEnum.getCodeByName(gstx));
        nonConformityObserveExcelPo.setGslx(NonConformityTypeEnum.getCodeByName(gslx));
        return nonConformityObserveExcelPo;
    }

    private static InternalAuditsExcelPo getInternalAuditsExcelPo(List<List<String>> result, int i) {
        List<String> data = result.get(i);
        InternalAuditsExcelPo internalAuditsExcelPo = new InternalAuditsExcelPo();
        String type = data.get(0);
        String auditReportsName = data.get(1);
        String auditReports = data.get(2);
        String auditPlanName = data.get(3);
        String auditPlan = data.get(4);
        String uploadTime = data.get(5);
        String orgName = data.get(6);
        String parentOrgName = data.get(7);
        internalAuditsExcelPo.setType(type);
        internalAuditsExcelPo.setAuditReportsName(auditReportsName);
        internalAuditsExcelPo.setAuditReports(auditReports);
        internalAuditsExcelPo.setAuditPlanName(auditPlanName);
        internalAuditsExcelPo.setAuditPlan(auditPlan);
        internalAuditsExcelPo.setUploadTime(uploadTime);
        internalAuditsExcelPo.setOrgName(orgName);
        internalAuditsExcelPo.setParentOrgName(parentOrgName);
        return internalAuditsExcelPo;
    }

    public InternalAuditsServerImpl(InternalAuditsDao internalAuditsDao, NonConformityDao nonConformityDao) {
        this.internalAuditsDao = internalAuditsDao;
        this.nonConformityDao = nonConformityDao;
    }
}

