package com.ejianc.business.quatity.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.InternalAuditsEntity;
import com.ejianc.business.quatity.entity.NonConformityEntity;
import com.ejianc.business.quatity.model.vo.CompanyTargetAddVo;
import com.ejianc.business.quatity.model.vo.InternalAuditsAddVo;
import com.ejianc.business.quatity.model.vo.NonConformityAddVo;
import com.ejianc.business.quatity.service.InternalAuditsServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:42
 * @Description: 内部审核
 */
@Controller
@RequestMapping("internalAudits")
@RequiredArgsConstructor
public class InternalAuditsController {
    private final InternalAuditsServer server;

    /**
     * 内部审核-新增
     *
     * @param vo InternalAuditsAddVo
     * @return 结果
     * @see CompanyTargetAddVo
     */
    @RequestMapping(value = "add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InternalAuditsEntity> add(@RequestBody @Valid InternalAuditsAddVo vo) {
        return CommonResponse.success("内部审核-新增成功", server.add(vo));
    }

    /**
     * 内部审核-查询
     *
     * @param param param
     * @return IPage<InternalAuditsEntity>
     */
    @RequestMapping(value = "list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InternalAuditsEntity>> list(@RequestBody QueryParam param) {
        return CommonResponse.success("内部审核-查询", server.list(param));
    }

    /**
     * 内部审核-详情
     *
     * @param id id
     * @return InternalAuditsEntity
     */
    @RequestMapping(value = "detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InternalAuditsEntity> detail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("内部审核-查询", server.detail(id));
    }

    /**
     * 内部审核-删除
     *
     * @param ids ids
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> del(@RequestBody @Valid List<Long> ids) {
        server.del(ids);
        return CommonResponse.success("内部审核-删除成功");
    }

    /**
     * 内部审核-导出
     *
     * @param ids      ids
     * @param response response
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> excelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.internalAuditsExcelExport(ids, response);
        return CommonResponse.success("内部审核-导出成功");
    }

    /**
     * 内部审核导入
     *
     * @param request  request
     * @param response response
     * @return结果
     */
    @RequestMapping(value = "excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> excelImport(HttpServletRequest request, HttpServletResponse response) {
        server.internalAuditsExcelImport(request, response);
        return CommonResponse.success("内部审核-导入成功");
    }

    /**
     * 不符合项-新增
     *
     * @param vo NonConformityAddVo
     * @return 结果
     * @see CompanyTargetAddVo
     */
    @RequestMapping(value = "nonConformity/add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<NonConformityEntity> nonConformityAdd(@RequestBody @Valid NonConformityAddVo vo) {
        return CommonResponse.success("内部审核-不符合项-新增成功", server.nonConformityAdd(vo));
    }

    /**
     * 不符合项-查询
     *
     * @param param param
     * @return IPage<InternalAuditsEntity>
     */
    @RequestMapping(value = "nonConformity/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<NonConformityEntity>> nonConformityList(@RequestBody QueryParam param) {
        return CommonResponse.success("内部审核-不符合项-查询", server.nonConformityList(param));
    }

    /**
     * 不符合项-详情
     *
     * @param id id
     * @return InternalAuditsEntity
     */
    @RequestMapping(value = "nonConformity/detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<NonConformityEntity> nonConformityDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("内部审核-不符合项-查询", server.nonConformityDetail(id));
    }

    /**
     * 不符合项-删除
     *
     * @param ids ids
     */

    @RequestMapping(value = "nonConformity/del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> nonConformityDel(@RequestBody @Valid List<Long> ids) {
        server.nonConformityDel(ids);
        return CommonResponse.success("内部审核-不符合项-删除成功");
    }

    /**
     * 不符合项导入
     * @param excelType 类型 observe观察项  ncr NCR
     * @param request  request
     * @param response response
     * @return结果
     */
    @RequestMapping(value = "nonConformity/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> nonConformityExcelImport(@RequestParam("excelType") String excelType,
                                                            HttpServletRequest request, HttpServletResponse response) {
        server.nonConformityExcelImport(excelType, request, response);
        return CommonResponse.success("内部审核-导入成功");
    }

    /**
     * 不符合-导出
     *
     * @param ids      ids
     * @param response response
     */
    @RequestMapping(value = "nonConformity/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> nonConformityExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.nonConformityExcelExport(ids, response);
        return CommonResponse.success("不符合-导出成功");
    }


}
