package com.ejianc.business.quatity.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quatity.entity.ReviewPlanEntity;
import com.ejianc.business.quatity.model.vo.ReleaseUnitSettingEditVo;
import com.ejianc.business.quatity.model.vo.ReviewPlanAddVo;
import com.ejianc.business.quatity.model.vo.ReviewPlanEditVo;
import com.ejianc.business.quatity.service.ReviewPlanServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午10:23
 * @Description: 评审管理-计划
 */
@Controller
@RequestMapping("reviewPlan")
@RequiredArgsConstructor
public class ReviewPlanController {
    private final ReviewPlanServer server;

    /**
     *  评审计划-新增
     * @param vo reviewPlanAddVo
     * @return  CommonResponse<reviewPlanEntity>
     */
    @RequestMapping(value = "reviewPlan/add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReviewPlanEntity> reviewPlanAdd(@RequestBody @Valid ReviewPlanAddVo vo) {
        return CommonResponse.success("公司目标-新增成功", server.reviewPlanAdd(vo));
    }

    /**
     * 编辑
     *
     * @param vo ReviewPlanEditVo
     * @return ReviewPlanEntity
     * @see ReviewPlanEditVo
     * @see ReviewPlanEntity
     */
    @RequestMapping(value = "reviewPlan/edit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReviewPlanEntity> reviewPlanEdit(@RequestBody @Valid ReviewPlanEditVo vo) {
        return CommonResponse.success("改进建议-编辑成功", server.reviewPlanEdit(vo));
    }

    /**
     *  评审计划-查询
     * @param param param
     * @return  CommonResponse<IPage<reviewPlanEntity>>
     */
    @RequestMapping(value = "reviewPlan/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReviewPlanEntity>> reviewPlanList(@RequestBody QueryParam param) {
        return CommonResponse.success("公司目标-新增成功", server.reviewPlanList(param));
    }

    /**
     * 评审计划-详情
     *
     * @param id id
     * @return CompanyGoalsEntity
     */
    @RequestMapping(value = "reviewPlan/detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReviewPlanEntity> reviewPlanDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("公司目标-查询", server.reviewPlanDetail(id));
    }

    /**
     * 评审计划-删除
     *
     * @param ids ids
     */
    @RequestMapping(value = "reviewPlan/del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> reviewPlanDel(@RequestBody @Valid List<Long> ids) {
        server.reviewPlanDel(ids);
        return CommonResponse.success("公司目标-删除成功");
    }

    /**
     * 评审计划-导出
     *
     * @param ids      ids
     * @param response response
     */
    @RequestMapping(value = "reviewPlan/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> companyExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.reviewPlanExcelExport(ids, response);
        return CommonResponse.success("评审计划-导出成功");
    }

    /**
     * 评审计划-导入
     *
     * @return 结果
     */
    @RequestMapping(value = "reviewPlan/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> companyExcelImport(HttpServletRequest request, HttpServletResponse response) {
        server.reviewPlanExcelImport(request, response);
        return CommonResponse.success("评审计划-导入成功");
    }
    
}
