package com.ejianc.business.quatity.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quatity.entity.ReviewPlanEntity;
import com.ejianc.business.quatity.entity.ReviewRefineAdviceEntity;
import com.ejianc.business.quatity.model.vo.ReleaseUnitSettingEditVo;
import com.ejianc.business.quatity.model.vo.ReviewPlanEditVo;
import com.ejianc.business.quatity.model.vo.ReviewRefineAdviceAddVo;
import com.ejianc.business.quatity.model.vo.ReviewRefineAdviceEditVo;
import com.ejianc.business.quatity.service.ReviewRefineAdviceServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;
/**
 * @Author: DJF
 * @Date: 2024/5/21 上午10:23
 * @Description: 评审管理-改进建议
 */
@Controller
@RequestMapping("reviewRefineAdvice")
@RequiredArgsConstructor
public class ReviewRefineAdviceController {
    private final ReviewRefineAdviceServer server;
    /**
     *  评审改进建议-新增
     * @param vo reviewRefineAdviceAddVo
     * @return  CommonResponse<reviewRefineAdviceEntity>
     */
    @RequestMapping(value = "reviewRefineAdvice/add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReviewRefineAdviceEntity> reviewRefineAdviceAdd(@RequestBody @Valid ReviewRefineAdviceAddVo vo) {
        return CommonResponse.success("改进建议-新增成功", server.reviewRefineAdviceAdd(vo));
    }

    /**
     * 编辑
     *
     * @param vo ReviewPlanEditVo
     * @return ReviewRefineAdviceEntity
     * @see ReviewPlanEditVo
     * @see ReviewRefineAdviceEntity
     */
    @RequestMapping(value = "reviewRefineAdvice/edit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReviewRefineAdviceEntity> reviewRefineAdviceEdit(@RequestBody @Valid ReviewRefineAdviceEditVo vo) {
        return CommonResponse.success("改进建议-编辑成功", server.reviewRefineAdviceEdit(vo));
    }

    /**
     *  评审改进建议-查询
     * @param param param
     * @return  CommonResponse<IPage<reviewRefineAdviceEntity>>
     */
    @RequestMapping(value = "reviewRefineAdvice/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReviewRefineAdviceEntity>> reviewRefineAdviceList(@RequestBody QueryParam param) {
        return CommonResponse.success("改进建议-新增成功", server.reviewRefineAdviceList(param));
    }

    /**
     * 评审改进建议-详情
     *
     * @param id id
     * @return CompanyGoalsEntity
     */
    @RequestMapping(value = "reviewRefineAdvice/detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReviewRefineAdviceEntity> reviewRefineAdviceDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("改进建议-查询", server.reviewRefineAdviceDetail(id));
    }

    /**
     * 评审改进建议-删除
     *
     * @param ids ids
     */
    @RequestMapping(value = "reviewRefineAdvice/del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> reviewRefineAdviceDel(@RequestBody @Valid List<Long> ids) {
        server.reviewRefineAdviceDel(ids);
        return CommonResponse.success("改进建议-删除成功");
    }

    /**
     * 评审改进建议-导出
     *
     * @param ids      ids
     * @param response response
     */
    @RequestMapping(value = "reviewRefineAdvice/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> companyExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.reviewRefineAdviceExcelExport(ids, response);
        return CommonResponse.success("评审改进建议-导出成功");
    }

    /**
     * 评审改进建议-导入
     *
     * @return 结果
     */
    @RequestMapping(value = "reviewRefineAdvice/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> companyExcelImport(HttpServletRequest request, HttpServletResponse response) {
        server.reviewRefineAdviceExcelImport(request, response);
        return CommonResponse.success("评审改进建议-导入成功");
    }
}
