package com.ejianc.business.quatity.dao.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.quatity.dao.ReleaseUnitSettingsDao;
import com.ejianc.business.quatity.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quatity.mapper.ReleaseUnitSettingsMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.common.collect.Maps;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.ConcurrentMap;

/**
 * @Author: LCL
 * @Date: 2024/5/13 下午2:06
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ReleaseUnitSettingsDaoImpl extends BaseServiceImpl<ReleaseUnitSettingsMapper, ReleaseUnitSettingsEntity> implements ReleaseUnitSettingsDao {
    private final SessionManager sessionManager;

    @Override
    public ConcurrentMap<String, String> getMapByTypeAndOrgId(String type) {
        Long orgId = sessionManager.getUserContext().getOrgId();
        List<ReleaseUnitSettingsEntity> list = lambdaQuery().eq(ReleaseUnitSettingsEntity::getType, type).eq(ReleaseUnitSettingsEntity::getOrgId, orgId).list();
        ConcurrentMap<String, String> codeNameMap = Maps.newConcurrentMap();
        list.forEach(e -> {
            String releaseUnitsCode = e.getReleaseUnitsCode();
            String releaseUnitsName = e.getReleaseUnitsName();
            List<String> codeList = JSONObject.parseArray(releaseUnitsCode, String.class);
            List<String> nameList = JSONObject.parseArray(releaseUnitsName, String.class);
            for (int i = 0; i < codeList.size(); i++) {
                codeNameMap.put(codeList.get(i), nameList.get(i));
            }
        });
        return codeNameMap;

    }
}
