package com.ejianc.business.quatity.model.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @Author: DJF
 * @Date: 2024/5/21 下午16:03
 * @Description: 评审管理-报告修改
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ReviewReportEditVo {

    @NotNull(message = "id不能为空")
    private Long id;

    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quatity.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;

    /**
     * 改进建议-文件主题
     */
    private String fileTopic;

    /**
     * 改进建议-文件名称
     */
    private String fileName;

    /**
     * 改进建议-文件附件
     */
    private String fileAttachment;

    /**
     * 改进建议-上传时间
     */
    private String uploadTime;

    /**
     * 改进建议-上传人
     */
    private String uploader;

    /**
     * 改进建议-上传项目
     */
    private String uploadProject;
}
