package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.dao.ReviewPlanDao;
import com.ejianc.business.quatity.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quatity.entity.ReviewPlanEntity;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.model.po.ReviewPlanExcelPo;
import com.ejianc.business.quatity.model.vo.ReleaseUnitSettingEditVo;
import com.ejianc.business.quatity.model.vo.ReviewPlanAddVo;
import com.ejianc.business.quatity.model.vo.ReviewPlanEditVo;
import com.ejianc.business.quatity.service.ReviewPlanServer;
import com.ejianc.business.quatity.util.DetailIndexExcelReader;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午9:50
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ReviewPlanServerImpl implements ReviewPlanServer {
    private final ReviewPlanDao reviewPlanDao;

    @Override
    public ReviewPlanEntity reviewPlanAdd(ReviewPlanAddVo vo) {
        ReviewPlanEntity reviewPlanEntity = new ReviewPlanEntity();
        BeanUtils.copyProperties(vo, reviewPlanEntity);
        try {
            reviewPlanDao.save(reviewPlanEntity);
            return reviewPlanEntity;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public ReviewPlanEntity reviewPlanEdit(ReviewPlanEditVo vo) {
        ReviewPlanEntity reviewPlanEntity = new ReviewPlanEntity();
        BeanUtils.copyProperties(vo, reviewPlanEntity);
        try {
//            reviewPlanEntity.setReleaseUnitsCode(JSONObject.toJSONString(vo.getReleaseUnitsCode()));
//            reviewPlanEntity.setReleaseUnitsName(JSONObject.toJSONString(vo.getReleaseUnitsName()));
            reviewPlanDao.updateById(reviewPlanEntity);
            return reviewPlanEntity;
        } catch (Exception e) {
            throw new BusinessException("编辑失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<ReviewPlanEntity> reviewPlanList(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("targetFileName");
//        fuzzyFields.add("orgName");
//        fuzzyFields.add("parentOrgName");


        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);

        return reviewPlanDao.queryPage(param, false);
    }

    @Override
    public ReviewPlanEntity reviewPlanDetail(Long id) {
        return reviewPlanDao.getById(id);
    }

    @Override
    public void reviewPlanDel(List<Long> ids) {
        try {
            reviewPlanDao.removeByIds(ids);
        } catch (Exception e) {
            throw new BusinessException("管理评审删除失败：" + e.getMessage());
        }
    }

    @Override
    public void reviewPlanExcelExport(List<Long> ids, HttpServletResponse response) {
        List<ReviewPlanEntity> list = reviewPlanDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        //导出展示类别中文处理
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());

            item.setType(type);
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewPlanExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("公司目标导出失败：" + e.getMessage());
        }
    }

    @Override
    public void reviewPlanExcelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<ReviewPlanExcelPo> reviewPlanExcelPoList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            throw new BusinessException("文件格式不合法");
        } else {
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                throw new BusinessException("文件页签不完整，请下载最新模板！");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            for (int i = 0; i < result.size(); i++) {
                ReviewPlanExcelPo reviewPlanExcelPo = getCompanyGoalsExcelPo(result, i);
                reviewPlanExcelPoList.add(reviewPlanExcelPo);
            }
        }


        try {
            List<ReviewPlanEntity> reviewPlanEntities = Lists.newArrayList();
            reviewPlanExcelPoList.forEach(companyGoalsExcelPo -> {
                ReviewPlanEntity reviewPlanEntity = new ReviewPlanEntity();
                BeanUtils.copyProperties(companyGoalsExcelPo, reviewPlanEntity);
                reviewPlanEntity.setUploadTime(DateUtil.parse(companyGoalsExcelPo.getUploadTime(), DateFormater.SHORT_FORMAT).toSqlDate());
                reviewPlanEntities.add(reviewPlanEntity);
            });
            reviewPlanDao.saveBatch(reviewPlanEntities);
        } catch (Exception e) {
            throw new BusinessException("公司目标导入保存异常");
        }
    }

    private static ReviewPlanExcelPo getCompanyGoalsExcelPo(List<List<String>> result, int i) {
        List<String> datas = result.get(i);
        ReviewPlanExcelPo reviewPlanExcelPo = new ReviewPlanExcelPo();
        String uploader = datas.get(0);//类别
        String fileTopic = datas.get(1);//目标文件名称
        String uploadProject = datas.get(2);//目标文件
        String uploadTime = datas.get(3);///目标上传日期
        String reviewPlanFile = datas.get(4);//所属项目部名称
        String parentOrgName = datas.get(5);
        reviewPlanExcelPo.setUploader(uploader);
        reviewPlanExcelPo.setFileTopic(fileTopic);
        reviewPlanExcelPo.setUploadProject(uploadProject);
        reviewPlanExcelPo.setReviewPlanFile(reviewPlanFile);
        reviewPlanExcelPo.setUploadTime(uploadTime);
//        reviewPlanExcelPo.setOrgName(orgName);
//        reviewPlanExcelPo.setParentOrgName(parentOrgName);
        return reviewPlanExcelPo;
    }
}
