package com.ejianc.business.quatity.service.impl.bpm;

import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;


/**
 * @Author: LCL
 * @Date: 2024/5/22 上午9:42
 * @Description: 经验反馈下达详情 审批流
 */
@Service("experienceFeedbackIssuedDetail")
@Slf4j
@RequiredArgsConstructor
public class ExperienceFeedbackIssuedDetailBpmServiceImpl implements ICommonBusinessService {

    @Qualifier("com.ejianc.foundation.support.api.IBillTypeApi")
    private final IBillTypeApi billTypeApi;

    /**
     * 提交前回调
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批前回调
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

}
