package com.ejianc.business.quatity.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;


/**
 * @Author: LCL
 * @Date: 2024/5/17 下午3:28
 * @Description: 下达单位设置
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_release_unit_settings")
public class ReleaseUnitSettingsEntity extends BaseEntity {
    /**
     * 所属类型(管理评审输入、经验反馈)
     */
    @TableField(value = "type")
    private String type;

    /**
     * 下达单位code JSON
     */
    @TableField(value = "release_units_code")
    private String releaseUnitsCode;

    /**
     * 下达单位name JSON
     */
    @TableField(value = "release_units_name")
    private String releaseUnitsName;

    /**
     * 编制人账号
     */
    @TableField(value = "prepared_user_code")
    private String preparedUserCode;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;
}
