package com.ejianc.business.quatity.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.SysDocInstitutionalLibEntity;
import com.ejianc.business.quatity.entity.SysDocStandardLibEntity;
import com.ejianc.business.quatity.model.vo.SysDocDelVo;
import com.ejianc.business.quatity.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quatity.model.vo.SysDocInstitutionalEditVo;
import com.ejianc.business.quatity.model.vo.SysDocStandardAddVo;
import com.ejianc.business.quatity.model.vo.SysDocStandardEditVo;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午4:05
 * @Description: 体系文件
 */
public interface SystemDocumentsServer {
    /**
     * 标准库——·
     *
     * @param vo SysDocStandardAddVo
     * @return SysDocStandardLibEntity
     * @see SysDocStandardAddVo
     */
    SysDocStandardLibEntity standardAdd(SysDocStandardAddVo vo);

    /**
     * 制度库——新增
     *
     * @param vo SysDocInstitutionalAddVo
     * @return SysDocInstitutionalLibEntity
     * @see SysDocInstitutionalAddVo
     */
    SysDocInstitutionalLibEntity institutionalAdd(SysDocInstitutionalAddVo vo);

    /**
     * 标准库——编辑
     *
     * @param vo SysDocStandardEditVo
     * @see SysDocStandardEditVo
     * @return SysDocStandardLibEntity
     */
    SysDocStandardLibEntity standardEdit(SysDocStandardEditVo vo);

    /**
     * 制度库——编辑
     *
     * @param vo SysDocInstitutionalEditVo
     * @see SysDocInstitutionalEditVo
     * @return SysDocInstitutionalLibEntity
     */
    SysDocInstitutionalLibEntity institutionalEdit(SysDocInstitutionalEditVo vo);

    /**
     * 标准库——查询
     *
     * @param param param
     * @return IPage<SysDocInstitutionalLibEntity>
     */
    IPage<SysDocStandardLibEntity> standardList(@Valid QueryParam param);

    /**
     * 制度库——查询
     *
     * @param param param
     * @return IPage<SysDocInstitutionalLibEntity>
     */
    IPage<SysDocInstitutionalLibEntity> institutionalList(QueryParam param);

    /**
     * 标准库——详情
     *
     * @param id id
     * @return SysDocStandardLibEntity
     */
    SysDocStandardLibEntity standardDetail(Long id);

    /**
     * 制度库——详情
     *
     * @param id id
     * @return SysDocInstitutionalLibEntity
     */
    SysDocInstitutionalLibEntity institutionalDetail(Long id);

    /**
     * 删除
     *
     * @param vo SysDocDelVo
     * @see SysDocDelVo
     */
    void del(SysDocDelVo vo);

    /**
     * 标准库——导出
     *
     * @param ids      数据id
     * @param response 请求
     * @return excel文件
     */
    void standardExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 制度库——导出
     *
     * @param ids      数据id
     * @param response 请求
     * @return excel文件
     */
    void institutionalExcelExport(List<Long> ids, HttpServletResponse response);
}
