/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.dao.ReviewReportDao;
import com.ejianc.business.quatity.entity.ReviewReportEntity;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.model.po.ReviewReportExcelPo;
import com.ejianc.business.quatity.model.vo.ReviewReportAddVo;
import com.ejianc.business.quatity.model.vo.ReviewReportEditVo;
import com.ejianc.business.quatity.service.ReviewReportServer;
import com.ejianc.business.quatity.util.DetailIndexExcelReader;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class ReviewReportServerImpl
implements ReviewReportServer {
    private static final Logger log = LoggerFactory.getLogger(ReviewReportServerImpl.class);
    private final ReviewReportDao reviewReportDao;

    @Override
    public ReviewReportEntity reviewReportAdd(ReviewReportAddVo vo) {
        ReviewReportEntity ReviewReportEntity2 = new ReviewReportEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)ReviewReportEntity2));
        try {
            this.reviewReportDao.save((Object)ReviewReportEntity2);
            return ReviewReportEntity2;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public ReviewReportEntity reviewReportEdit(ReviewReportEditVo vo) {
        ReviewReportEntity reviewReportEntity = new ReviewReportEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)reviewReportEntity));
        try {
            this.reviewReportDao.updateById((Object)reviewReportEntity);
            return reviewReportEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u7f16\u8f91\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<ReviewReportEntity> reviewReportList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>(param.getOrderMap());
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        return this.reviewReportDao.queryPage(param, false);
    }

    @Override
    public ReviewReportEntity reviewReportDetail(Long id) {
        return (ReviewReportEntity)((Object)this.reviewReportDao.getById(id));
    }

    @Override
    public void reviewReportDel(List<Long> ids) {
        try {
            this.reviewReportDao.removeByIds(ids);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ba1\u7406\u8bc4\u5ba1\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void reviewReportExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.reviewReportDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());
            item.setType(type);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("ReviewReportExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u516c\u53f8\u76ee\u6807\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void reviewReportExcelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<ReviewReportExcelPo> reportExcelPoList = new ArrayList<ReviewReportExcelPo>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            throw new BusinessException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            throw new BusinessException("\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        for (int i = 0; i < result.size(); ++i) {
            ReviewReportExcelPo reviewReportExcelPo2 = ReviewReportServerImpl.getCompanyGoalsExcelPo(result, i);
            reportExcelPoList.add(reviewReportExcelPo2);
        }
        try {
            List reviewReportEntities = Lists.newArrayList();
            reportExcelPoList.forEach(reviewReportExcelPo -> {
                ReviewReportEntity reviewReportEntity = new ReviewReportEntity();
                BeanUtils.copyProperties((Object)reviewReportExcelPo, (Object)((Object)reviewReportEntity));
                reviewReportEntity.setUploadTime(DateUtil.parse((String)reviewReportExcelPo.getUploadTime(), (String)"yyyy-MM-dd").toSqlDate());
                reviewReportEntities.add(reviewReportEntity);
            });
            this.reviewReportDao.saveBatch(reviewReportEntities);
        }
        catch (Exception e) {
            throw new BusinessException("\u516c\u53f8\u76ee\u6807\u5bfc\u5165\u4fdd\u5b58\u5f02\u5e38");
        }
    }

    private static ReviewReportExcelPo getCompanyGoalsExcelPo(List<List<String>> result, int i) {
        List<String> datas = result.get(i);
        ReviewReportExcelPo reviewReportExcelPo = new ReviewReportExcelPo();
        String fileTopic = datas.get(0);
        String fileName = datas.get(1);
        String fileAttachment = datas.get(2);
        String uploader = datas.get(3);
        String uploadTime = datas.get(4);
        String uploadProject = datas.get(4);
        String orgName = datas.get(5);
        String parentOrgName = datas.get(6);
        reviewReportExcelPo.setFileTopic(fileTopic);
        reviewReportExcelPo.setFileName(fileName);
        reviewReportExcelPo.setFileAttachment(fileAttachment);
        reviewReportExcelPo.setUploader(uploader);
        reviewReportExcelPo.setUploadTime(uploadTime);
        reviewReportExcelPo.setUploadProject(uploadProject);
        reviewReportExcelPo.setOrgName(orgName);
        reviewReportExcelPo.setParentOrgName(parentOrgName);
        return reviewReportExcelPo;
    }

    public ReviewReportServerImpl(ReviewReportDao reviewReportDao) {
        this.reviewReportDao = reviewReportDao;
    }
}

