package com.ejianc.business.quatity.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedEntity;
import com.ejianc.business.quatity.model.res.ExperienceFeedbackIssuedRes;
import com.ejianc.business.quatity.model.vo.ExpFeedBackIssuedAddVo;
import com.ejianc.business.quatity.model.vo.ExpFeedBackIssuedEditVo;
import com.ejianc.business.quatity.service.ExperienceFeedbackServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/5/15 上午10:08
 * @Description: 经验反馈
 */
@Controller
@RequestMapping("experienceFeedback")
@RequiredArgsConstructor
public class ExperienceFeedbackController {
    private final ExperienceFeedbackServer server;
    /**
     * 下达 issued
     */
    /**
     * 下达-新增
     *
     * @param vo ExpFeedBackIssuedAddVo
     * @return ExperienceFeedbackIssuedEntity
     */
    @RequestMapping(value = "issued/add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExperienceFeedbackIssuedEntity> issuedAdd(@RequestBody @Valid ExpFeedBackIssuedAddVo vo) {
        return CommonResponse.success("经验反馈下达-新增成功", server.issuedAdd(vo));
    }
    /**
     * 根据配置一键下达
     */


    /**
     * 下达-删除
     *
     * @param ids ids
     * @return 结果
     */
    @RequestMapping(value = "issued/del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> issuedDel(@RequestBody List<Long> ids) {
        server.issuedDel(ids);
        return CommonResponse.success("经验反馈下达-删除成功");
    }

    /**
     * 下达-修改
     *
     * @param vo ExpFeedBackIssuedEditVo
     * @return ExperienceFeedbackIssuedEntity
     */
    @RequestMapping(value = "issued/edit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExperienceFeedbackIssuedEntity> issuedEdit(@RequestBody @Valid ExpFeedBackIssuedEditVo vo) {
        return CommonResponse.success("经验反馈下达-修改成功", server.issuedEdit(vo));
    }

    /**
     * 下达-详情
     *
     * @param id id
     * @return ExperienceFeedbackIssuedRes
     */
    @RequestMapping(value = "issued/detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExperienceFeedbackIssuedRes> issuedDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("经验反馈下达-详情", server.issuedDetail(id));
    }

    /**
     * 下达-列表
     *
     * @param param param
     * @return ExperienceFeedbackIssuedRes
     */
    @RequestMapping(value = "issued/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExperienceFeedbackIssuedRes>> issuedList(@RequestBody QueryParam param) {
        return CommonResponse.success("经验反馈下达-列表", server.issuedList(param));
    }

    /**
     * 下达-导入
     */
//    @RequestMapping(value = "issued/excelImport", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<JSONObject> issuedExcelImport(HttpServletRequest request) {
//        return server.issuedExcelImport(request);
//    }

    /**
     * 下达导入保存
     */
//    @RequestMapping(value = "issued/excelImport/save", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<Boolean> issuedExcelImportSave(@RequestBody List<ExperienceFeedbackIssuedEntity> importVos) {
//        if (ListUtil.isEmpty(importVos)) {
//            return CommonResponse.error("导入的数据为空！");
//        }
//        server.issuedExcelImportSave(importVos);
//        return CommonResponse.success("内部审核-导入成功");
//    }

    /**
     * 下达-导出
     *
     * @param ids      ids
     * @param response response
     */
    @RequestMapping(value = "issued/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> issuedExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.issuedExcelExport(ids, response);
        return CommonResponse.success("经验反馈下达-导出成功");
    }

    /**
     * 被下达部门上报
     */



}
