package com.ejianc.business.quatity.dao;

import com.ejianc.business.quatity.entity.ReleaseUnitSettingsEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.concurrent.ConcurrentMap;

/**
 * @Author: LCL
 * @Date: 2024/5/17 下午3:31
 * @Description: 下达单位设置
 */
public interface ReleaseUnitSettingsDao extends IBaseService<ReleaseUnitSettingsEntity> {
    /**
     * 根据下达单位设置的类型和当前请求的org_id获取 map
     *
     * @param type 所属类型(管理评审输入、经验反馈)
     * @return Map<String, String>  Map<下达单位code,下达单位name>
     */
    ConcurrentMap<String, String> getMapByTypeAndOrgId(String type);
}
