package com.ejianc.business.quatity.model.res;

import com.ejianc.business.quatity.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.sql.Date;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/21 上午11:19
 * @Description: 经验反馈下达返回
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ExperienceFeedbackIssuedRes extends BaseEntity {
    /**
     * 归属类型——专业
     */
    private String attributionTypeSpecialized;

    /**
     * 主题
     */
    private String topic;

    /**
     * 内容
     */
    private String substance;

    /**
     * 下达单位code JSON
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private String releaseUnitsCode;

    /**
     * 下达单位name JSON
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private String releaseUnitsName;

    /**
     * 完成情况
     */
    private String completion;

    /**
     * 下达时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date releaseTime;

    /**
     * 编制人code
     */
    private String preparedUserCode;

    /**
     * 编制人name
     */
    private String preparedUserName;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    private String parentOrgName;

    /**
     * 详情列表
     */
    private List<ExperienceFeedbackIssuedDetailEntity> detailList;

}
