package com.ejianc.business.quatity.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quatity.model.res.ReleaseUnitSettingsRes;
import com.ejianc.business.quatity.model.vo.ReleaseUnitSettingAddVo;
import com.ejianc.business.quatity.model.vo.ReleaseUnitSettingEditVo;
import com.ejianc.framework.core.response.QueryParam;

import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午4:05
 * @Description: 目标管理
 */
public interface ReleaseUnitSettingServer {
    /**
     * 新增
     *
     * @param vo ReleaseUnitSettingAddVo
     * @return ReleaseUnitSettingsEntity
     * @see ReleaseUnitSettingAddVo
     * @see ReleaseUnitSettingsEntity
     */
    ReleaseUnitSettingsEntity add(ReleaseUnitSettingAddVo vo);

    /**
     * 编辑
     *
     * @param vo ReleaseUnitSettingEditVo
     * @return ReleaseUnitSettingsEntity
     * @see ReleaseUnitSettingEditVo
     * @see ReleaseUnitSettingsEntity
     */
    ReleaseUnitSettingsEntity edit(ReleaseUnitSettingEditVo vo);

    /**
     * 查询
     *
     * @param param param
     * @return IPage<ReleaseUnitSettingsEntity>
     */
    IPage<ReleaseUnitSettingsRes> list(QueryParam param);

    /**
     * 详情
     *
     * @param id id
     * @return ReleaseUnitSettingsEntity
     */
    ReleaseUnitSettingsRes detail(Long id);

    /**
     * 删除
     *
     * @param ids ids
     */
    void del(List<Long> ids);
}
